/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.robotics.math.filters.RateLimitedYoFramePoint;
import us.ihmc.robotics.math.filters.RateLimitedYoFrameQuaternion;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class RateLimitedYoFramePose
implements FixedFramePose3DBasics {
    private final RateLimitedYoFramePoint position;
    private final RateLimitedYoFrameQuaternion orientation;

    private static DoubleProvider createMaxRateYoDouble(String namePrefix, String nameSuffix, double initialValue, YoRegistry registry) {
        YoDouble maxRate = new YoDouble(namePrefix + "MaxRate" + nameSuffix, registry);
        maxRate.set(initialValue);
        return maxRate;
    }

    public RateLimitedYoFramePose(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, FramePose3DReadOnly rawPose) {
        this(namePrefix, nameSuffix, registry, maxRate, dt, rawPose, rawPose.getReferenceFrame());
    }

    public RateLimitedYoFramePose(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, maxRate, dt, null, referenceFrame);
    }

    public RateLimitedYoFramePose(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, FramePose3DReadOnly rawPose) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFramePose.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, rawPose, rawPose.getReferenceFrame());
    }

    public RateLimitedYoFramePose(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFramePose.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, null, referenceFrame);
    }

    private RateLimitedYoFramePose(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, FramePose3DReadOnly rawPose, ReferenceFrame referenceFrame) {
        if (rawPose != null) {
            this.position = new RateLimitedYoFramePoint(namePrefix, "Position" + nameSuffix, registry, maxRate, dt, (FrameTuple3DReadOnly)rawPose.getPosition());
            this.orientation = new RateLimitedYoFrameQuaternion(namePrefix, "Orientation" + nameSuffix, registry, maxRate, dt, rawPose.getOrientation());
        } else {
            this.position = new RateLimitedYoFramePoint(namePrefix, "Position" + nameSuffix, registry, maxRate, dt, referenceFrame);
            this.orientation = new RateLimitedYoFrameQuaternion(namePrefix, "Orientation" + nameSuffix, registry, maxRate, dt, referenceFrame);
        }
        this.reset();
    }

    public void reset() {
        this.position.reset();
        this.orientation.reset();
    }

    public void update() {
        this.position.update();
        this.orientation.update();
        this.set((FrameTuple3DReadOnly)this.position, (FrameOrientation3DReadOnly)this.orientation);
    }

    public void update(FramePose3DReadOnly framePoseUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)framePoseUnfiltered);
        this.position.update((FrameTuple3DReadOnly)framePoseUnfiltered.getPosition());
        this.orientation.update(framePoseUnfiltered.getOrientation());
        this.set((FrameTuple3DReadOnly)this.position, (FrameOrientation3DReadOnly)this.orientation);
    }

    public FixedFramePoint3DBasics getPosition() {
        return this.position;
    }

    public FixedFrameQuaternionBasics getOrientation() {
        return this.orientation;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.position.getReferenceFrame();
    }

    public String toString() {
        return EuclidGeometryIOTools.getPose3DString((Pose3DReadOnly)this) + "-" + this.getReferenceFrame();
    }
}

