/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class RateLimitedYoFramePoint
extends YoFramePoint3D {
    private final DoubleProvider maxRateVariable;
    private final FrameTuple3DReadOnly rawPosition;
    private final YoBoolean limited;
    private final YoBoolean hasBeenCalled;
    private final double dt;
    private final FrameVector3D differenceVector = new FrameVector3D();

    private static DoubleProvider createMaxRateYoDouble(String namePrefix, String nameSuffix, double initialValue, YoRegistry registry) {
        YoDouble maxRate = new YoDouble(namePrefix + "MaxRate" + nameSuffix, registry);
        maxRate.set(initialValue);
        return maxRate;
    }

    public RateLimitedYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, FrameTuple3DReadOnly rawPosition) {
        this(namePrefix, nameSuffix, registry, maxRate, dt, rawPosition, rawPosition.getReferenceFrame());
    }

    public RateLimitedYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, maxRate, dt, null, referenceFrame);
    }

    public RateLimitedYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, FrameTuple3DReadOnly rawPosition) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFramePoint.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, rawPosition, rawPosition.getReferenceFrame());
    }

    public RateLimitedYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFramePoint.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, null, referenceFrame);
    }

    private RateLimitedYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, FrameTuple3DReadOnly rawPosition, ReferenceFrame referenceFrame) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.hasBeenCalled = new YoBoolean(namePrefix + "HasBeenCalled" + nameSuffix, registry);
        this.limited = new YoBoolean(namePrefix + "Limited" + nameSuffix, registry);
        if (maxRate == null) {
            maxRate = RateLimitedYoFramePoint.createMaxRateYoDouble(namePrefix, nameSuffix, Double.POSITIVE_INFINITY, registry);
        }
        this.maxRateVariable = maxRate;
        this.rawPosition = rawPosition;
        this.dt = dt;
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.rawPosition == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.rawPosition);
    }

    public void update(FrameTuple3DReadOnly frameVectorUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameVectorUnfiltered);
        this.update(frameVectorUnfiltered.getX(), frameVectorUnfiltered.getY(), frameVectorUnfiltered.getZ());
    }

    public void update(Tuple3DReadOnly vectorUnfiltered) {
        this.update(vectorUnfiltered.getX(), vectorUnfiltered.getY(), vectorUnfiltered.getZ());
    }

    public void update(double xUnfiltered, double yUnfiltered, double zUnfiltered) {
        if (!this.hasBeenCalled.getBooleanValue() || this.containsNaN()) {
            this.hasBeenCalled.set(true);
            this.set(xUnfiltered, yUnfiltered, zUnfiltered);
        }
        if (this.maxRateVariable.getValue() < 0.0) {
            throw new RuntimeException("The maxRate parameter in the " + ((Object)((Object)this)).getClass().getSimpleName() + " cannot be negative.");
        }
        this.differenceVector.setToZero(this.getReferenceFrame());
        this.differenceVector.set(xUnfiltered, yUnfiltered, zUnfiltered);
        this.differenceVector.sub(this.getX(), this.getY(), this.getZ());
        this.limited.set(this.differenceVector.clipToMaxLength(this.maxRateVariable.getValue() * this.dt));
        this.add((FrameTuple3DReadOnly)this.differenceVector);
    }
}

