/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.geometry.RotationTools;

public class OrientationNumericalDifferentiator {
    public static FrameVector3D differentiate(double dt, ReferenceFrame frame, FrameQuaternion before, FrameQuaternion current, FrameQuaternion after) {
        ReferenceFrame beforeInitialFrame = before.getReferenceFrame();
        ReferenceFrame currentInitialFrame = current.getReferenceFrame();
        ReferenceFrame afterInitialFrame = after.getReferenceFrame();
        before.changeFrame(frame);
        current.changeFrame(frame);
        after.changeFrame(frame);
        RotationMatrix oRbtm1 = new RotationMatrix((Orientation3DReadOnly)before);
        RotationMatrix btm1Ro = new RotationMatrix();
        btm1Ro.setAndInvert((RotationMatrixReadOnly)oRbtm1);
        RotationMatrix oRbt1 = new RotationMatrix((Orientation3DReadOnly)after);
        RotationMatrix btRbt1 = new RotationMatrix();
        btRbt1.set(btm1Ro);
        btRbt1.multiply((RotationMatrixReadOnly)oRbt1);
        AxisAngle w = new AxisAngle();
        AxisAngleConversion.convertMatrixToAxisAngle((RotationMatrixReadOnly)btRbt1, (AxisAngleBasics)w);
        Vector3D vbt = new Vector3D(w.getX(), w.getY(), w.getZ());
        vbt.normalize();
        vbt.scale(w.getAngle() / (2.0 * dt));
        RotationMatrix oRbt = new RotationMatrix((Orientation3DReadOnly)current);
        Vector3D vwt = OrientationNumericalDifferentiator.mul3((Matrix3DReadOnly)oRbt, (Vector3DReadOnly)vbt);
        before.changeFrame(beforeInitialFrame);
        current.changeFrame(currentInitialFrame);
        after.changeFrame(afterInitialFrame);
        return new FrameVector3D(frame, (Tuple3DReadOnly)vwt);
    }

    public static List<FrameVector3D> differentiate(double dt, ReferenceFrame frame, List<FrameQuaternion> orientations) {
        ArrayList<FrameVector3D> vs = new ArrayList<FrameVector3D>(orientations.size());
        for (int i = 1; i < orientations.size() - 1; ++i) {
            FrameVector3D v = OrientationNumericalDifferentiator.differentiate(dt, frame, orientations.get(i - 1), orientations.get(i), orientations.get(i + 1));
            vs.add(v);
        }
        vs.add(0, new FrameVector3D((FrameTuple3DReadOnly)vs.get(0)));
        vs.add(new FrameVector3D((FrameTuple3DReadOnly)vs.get(vs.size() - 1)));
        return vs;
    }

    public static Vector3D differentiate2(double dt, ReferenceFrame frame, FrameQuaternion before, FrameQuaternion current, FrameQuaternion after) {
        ReferenceFrame beforeInitialFrame = before.getReferenceFrame();
        ReferenceFrame currentInitialFrame = current.getReferenceFrame();
        ReferenceFrame afterInitialFrame = after.getReferenceFrame();
        before.changeFrame(frame);
        current.changeFrame(frame);
        after.changeFrame(frame);
        double yaw = current.getYaw();
        double pitch = current.getPitch();
        double roll = current.getRoll();
        double dyaw = (after.getYaw() - before.getYaw()) / (2.0 * dt);
        double dpitch = (after.getPitch() - before.getPitch()) / (2.0 * dt);
        double droll = (after.getRoll() - before.getRoll()) / (2.0 * dt);
        Matrix3D R = new Matrix3D();
        R.set(1.0, 0.0, -Math.sin(pitch), 0.0, Math.cos(roll), Math.sin(roll) * Math.cos(pitch), 0.0, -Math.sin(roll), Math.cos(roll) * Math.cos(pitch));
        Vector3D vE = new Vector3D(droll, dpitch, dyaw);
        Vector3D vbt = OrientationNumericalDifferentiator.mul3((Matrix3DReadOnly)R, (Vector3DReadOnly)vE);
        RotationMatrix oRbt = new RotationMatrix((Orientation3DReadOnly)current);
        Vector3D vwt = OrientationNumericalDifferentiator.mul3((Matrix3DReadOnly)oRbt, (Vector3DReadOnly)vbt);
        before.changeFrame(beforeInitialFrame);
        current.changeFrame(currentInitialFrame);
        after.changeFrame(afterInitialFrame);
        return vwt;
    }

    private static Vector3D mul3(Matrix3DReadOnly M, Vector3DReadOnly v) {
        Matrix3D V = new Matrix3D();
        V.set(v.getX(), v.getX(), v.getX(), v.getY(), v.getY(), v.getY(), v.getZ(), v.getZ(), v.getZ());
        Matrix3D MV = new Matrix3D();
        MV.set(M);
        MV.multiply((Matrix3DReadOnly)V);
        return new Vector3D(MV.getM00(), MV.getM11(), MV.getM22());
    }

    public static void main(String[] args) {
        Vector3D initialVelocity = new Vector3D(1.0, 1.0, 1.0);
        double time = 0.01;
        RotationMatrix initialRotation = new RotationMatrix();
        initialRotation.setYawPitchRoll(1.0, 1.0, 1.0);
        RotationMatrix m1 = new RotationMatrix();
        m1.set(initialRotation);
        RotationMatrix m1inv = new RotationMatrix();
        m1inv.setAndInvert((RotationMatrixReadOnly)m1);
        RotationMatrix m21 = new RotationMatrix();
        Vector3D velIn1 = OrientationNumericalDifferentiator.mul3((Matrix3DReadOnly)m1inv, (Vector3DReadOnly)initialVelocity);
        RotationTools.integrateAngularVelocity((Vector3DReadOnly)velIn1, time, m21);
        RotationMatrix m2 = new RotationMatrix();
        m2.set(m1);
        m2.multiply((RotationMatrixReadOnly)m21);
        RotationMatrix m2inv = new RotationMatrix();
        m2inv.setAndInvert((RotationMatrixReadOnly)m2);
        RotationMatrix m32 = new RotationMatrix();
        Vector3D velIn2 = OrientationNumericalDifferentiator.mul3((Matrix3DReadOnly)m2inv, (Vector3DReadOnly)initialVelocity);
        RotationTools.integrateAngularVelocity((Vector3DReadOnly)velIn2, time, m32);
        RotationMatrix m3 = new RotationMatrix();
        m3.set(m2);
        m3.multiply((RotationMatrixReadOnly)m32);
        FrameQuaternion f1 = new FrameQuaternion(ReferenceFrame.getWorldFrame(), (Orientation3DReadOnly)m1);
        FrameQuaternion f2 = new FrameQuaternion(ReferenceFrame.getWorldFrame(), (Orientation3DReadOnly)m2);
        FrameQuaternion f3 = new FrameQuaternion(ReferenceFrame.getWorldFrame(), (Orientation3DReadOnly)m3);
        System.out.println(f1);
        System.out.println(f2);
        System.out.println(f3);
        System.out.println(initialVelocity);
        System.out.println(OrientationNumericalDifferentiator.differentiate(0.01, ReferenceFrame.getWorldFrame(), f1, f2, f3));
        System.out.println(OrientationNumericalDifferentiator.differentiate2(0.01, ReferenceFrame.getWorldFrame(), f1, f2, f3));
    }
}

