/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.commons.MathTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class JerkLimitedYoVariable
extends YoDouble {
    private final double dt;
    private final YoBoolean hasBeenInitialized;
    private final YoDouble smoothedRate;
    private final YoDouble smoothedAcceleration;
    private final YoDouble smoothedJerk;
    private final YoDouble positionGain;
    private final YoDouble velocityGain;
    private final YoDouble accelerationGain;
    private final YoDouble maximumJerk;
    private final YoDouble maximumAcceleration;
    private final YoDouble inputPosition;
    private final YoDouble inputVelocity;
    private final YoDouble inputAcceleration;

    public JerkLimitedYoVariable(String name, YoRegistry registry, YoDouble maxAcceleration, YoDouble maxJerk, double dt) {
        this(name, registry, maxAcceleration, maxJerk, null, null, null, dt);
    }

    public JerkLimitedYoVariable(String name, YoRegistry registry, YoDouble maxAcceleration, YoDouble maxJerk, YoDouble inputPosition, double dt) {
        this(name, registry, maxAcceleration, maxJerk, inputPosition, null, null, dt);
    }

    public JerkLimitedYoVariable(String name, YoRegistry registry, YoDouble maxAcceleration, YoDouble maxJerk, YoDouble inputPosition, YoDouble inputVelocity, double dt) {
        this(name, registry, maxAcceleration, maxJerk, inputPosition, inputVelocity, null, dt);
    }

    public JerkLimitedYoVariable(String name, YoRegistry registry, YoDouble maxAcceleration, YoDouble maxJerk, YoDouble inputPosition, YoDouble inputVelocity, YoDouble inputAcceleration, double dt) {
        super(name, registry);
        this.inputPosition = inputPosition;
        this.inputVelocity = inputVelocity;
        this.inputAcceleration = inputAcceleration;
        this.maximumJerk = maxJerk;
        this.maximumAcceleration = maxAcceleration;
        this.dt = dt;
        this.hasBeenInitialized = new YoBoolean(name + "HasBeenInitialized", registry);
        this.smoothedRate = new YoDouble(name + "SmoothedRate", registry);
        this.smoothedAcceleration = new YoDouble(name + "SmoothedAcceleration", registry);
        this.smoothedJerk = new YoDouble(name + "SmoothedJerk", registry);
        this.positionGain = new YoDouble(name + "PositionGain", registry);
        this.velocityGain = new YoDouble(name + "VelocityGain", registry);
        this.accelerationGain = new YoDouble(name + "AccelerationGain", registry);
        double w0 = 100.53096491487338;
        double w1 = 100.53096491487338;
        double zeta = 1.0;
        this.setGainsByPolePlacement(w0, w1, zeta);
        this.hasBeenInitialized.set(false);
    }

    public void setMaximumAcceleration(double maximumAcceleration) {
        this.maximumAcceleration.set(maximumAcceleration);
    }

    public void setMaximumJerk(double maximumJerk) {
        this.maximumJerk.set(maximumJerk);
    }

    public void setGainsByPolePlacement(double w0, double w1, double zeta) {
        this.positionGain.set(w0 * w1 * w1);
        this.velocityGain.set(w1 * w1 + 2.0 * zeta * w1 * w0);
        this.accelerationGain.set(w0 + 2.0 * zeta * w1);
    }

    public void update() {
        double inputPosition = this.inputPosition == null ? 0.0 : this.inputPosition.getDoubleValue();
        double inputVelocity = this.inputVelocity == null ? 0.0 : this.inputVelocity.getDoubleValue();
        double inputAcceleration = this.inputAcceleration == null ? 0.0 : this.inputAcceleration.getDoubleValue();
        this.update(inputPosition, inputVelocity, inputAcceleration);
    }

    public void update(double inputPosition) {
        this.update(inputPosition, 0.0, 0.0);
    }

    public void update(double inputPosition, double inputVelocity) {
        this.update(inputPosition, inputVelocity, 0.0);
    }

    public void update(double inputPosition, double inputVelocity, double inputAcceleration) {
        if (!this.hasBeenInitialized.getBooleanValue()) {
            this.initialize(inputPosition, inputVelocity, inputAcceleration);
        }
        double positionError = inputPosition - this.getDoubleValue();
        double velocityError = inputVelocity - this.smoothedRate.getDoubleValue();
        double accelerationError = inputAcceleration - this.smoothedAcceleration.getDoubleValue();
        double jerk = this.accelerationGain.getDoubleValue() * accelerationError + this.velocityGain.getDoubleValue() * velocityError + this.positionGain.getDoubleValue() * positionError;
        jerk = MathTools.clamp((double)jerk, (double)(-this.maximumJerk.getDoubleValue()), (double)this.maximumJerk.getDoubleValue());
        this.smoothedJerk.set(jerk);
        this.smoothedAcceleration.add(this.smoothedJerk.getDoubleValue() * this.dt);
        this.smoothedAcceleration.set(MathTools.clamp((double)this.smoothedAcceleration.getDoubleValue(), (double)this.maximumJerk.getDoubleValue()));
        this.smoothedRate.add(this.smoothedAcceleration.getDoubleValue() * this.dt);
        this.add(this.smoothedRate.getDoubleValue() * this.dt);
    }

    public void initialize(double inputPosition, double inputVelocity, double inputAcceleration) {
        this.set(inputPosition);
        this.smoothedRate.set(inputVelocity);
        this.smoothedAcceleration.set(inputAcceleration);
        this.smoothedJerk.set(0.0);
        this.hasBeenInitialized.set(true);
    }

    public void reset() {
        this.hasBeenInitialized.set(false);
        this.smoothedRate.set(0.0);
        this.smoothedAcceleration.set(0.0);
        this.smoothedJerk.set(0.0);
    }
}

