/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class FilteredVelocityYoVariable
extends YoDouble
implements ProcessingYoVariable {
    private double alphaDouble;
    private final double dt;
    private final DoubleProvider alphaVariable;
    private final YoDouble position;
    private final YoDouble lastPosition;
    private final YoBoolean hasBeenCalled;

    public FilteredVelocityYoVariable(String name, String description, double alpha, double dt, YoRegistry registry) {
        super(name, description, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.alphaDouble = alpha;
        this.dt = dt;
        this.alphaVariable = null;
        this.position = null;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.reset();
    }

    public FilteredVelocityYoVariable(String name, String description, double alpha, YoDouble positionVariable, double dt, YoRegistry registry) {
        super(name, description, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.alphaDouble = alpha;
        this.position = positionVariable;
        this.dt = dt;
        this.alphaVariable = null;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.reset();
    }

    public FilteredVelocityYoVariable(String name, String description, DoubleProvider alphaVariable, YoDouble positionVariable, double dt, YoRegistry registry) {
        super(name, description, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.position = positionVariable;
        this.alphaVariable = alphaVariable;
        this.alphaDouble = 0.0;
        this.dt = dt;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.reset();
    }

    public FilteredVelocityYoVariable(String name, String description, DoubleProvider alphaVariable, double dt, YoRegistry registry) {
        super(name, description, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.position = null;
        this.alphaVariable = alphaVariable;
        this.alphaDouble = 0.0;
        this.dt = dt;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.reset();
    }

    @Override
    public void reset() {
        this.hasBeenCalled.set(false);
    }

    @Override
    public void update() {
        if (this.position == null) {
            throw new NullPointerException("YoFilteredVelocityVariable must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position.getDoubleValue());
    }

    public void updateForAngles() {
        if (this.position == null) {
            throw new NullPointerException("YoFilteredVelocityVariable must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.updateForAngles(this.position.getDoubleValue());
    }

    public void update(double currentPosition) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.lastPosition.set(currentPosition);
            this.set(0.0);
        }
        double difference = currentPosition - this.lastPosition.getDoubleValue();
        this.updateUsingDifference(difference);
        this.lastPosition.set(currentPosition);
    }

    public void updateForAngles(double currentPosition) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.lastPosition.set(currentPosition);
            this.set(0.0);
        }
        double difference = AngleTools.computeAngleDifferenceMinusPiToPi(currentPosition, this.lastPosition.getDoubleValue());
        this.updateUsingDifference(difference);
        this.lastPosition.set(currentPosition);
    }

    private void updateUsingDifference(double difference) {
        double previousFilteredDerivative = this.getDoubleValue();
        double currentRawDerivative = difference / this.dt;
        double alpha = this.alphaVariable == null ? this.alphaDouble : this.alphaVariable.getValue();
        this.set(alpha * previousFilteredDerivative + (1.0 - alpha) * currentRawDerivative);
    }

    public void setAlpha(double alpha) {
        if (this.alphaVariable != null) {
            throw new RuntimeException("A double provider was used to construct this filtered variable. Modyfy the value of that provider directly.");
        }
        this.alphaDouble = alpha;
    }
}

