/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.robotics.math.filters.BetaFilteredYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class BetaFilteredYoFrameVector2d
extends YoFrameVector2D {
    private final BetaFilteredYoVariable x;
    private final BetaFilteredYoVariable y;

    private BetaFilteredYoFrameVector2d(BetaFilteredYoVariable x, BetaFilteredYoVariable y, ReferenceFrame referenceFrame) {
        super((YoDouble)x, (YoDouble)y, referenceFrame);
        this.x = x;
        this.y = y;
    }

    public static BetaFilteredYoFrameVector2d createBetaFilteredYoFrameVector2d(String namePrefix, String nameSuffix, YoRegistry registry, int beta, ReferenceFrame referenceFrame) {
        BetaFilteredYoVariable x = new BetaFilteredYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), registry, beta);
        BetaFilteredYoVariable y = new BetaFilteredYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), registry, beta);
        BetaFilteredYoFrameVector2d ret = new BetaFilteredYoFrameVector2d(x, y, referenceFrame);
        return ret;
    }

    public static BetaFilteredYoFrameVector2d createBetaFilteredYoFrameVector2d(String namePrefix, String nameSuffix, YoRegistry registry, int beta, YoFrameVector2D unfilteredVector) {
        BetaFilteredYoVariable x = new BetaFilteredYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), registry, beta, unfilteredVector.getYoX());
        BetaFilteredYoVariable y = new BetaFilteredYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), registry, beta, unfilteredVector.getYoY());
        BetaFilteredYoFrameVector2d ret = new BetaFilteredYoFrameVector2d(x, y, unfilteredVector.getReferenceFrame());
        return ret;
    }

    public void update() {
        this.x.update();
        this.y.update();
    }

    public void update(double xUnfiltered, double yUnfiltered) {
        this.x.update(xUnfiltered);
        this.y.update(yUnfiltered);
    }

    public void update(Vector2D vector2dUnfiltered) {
        this.x.update(vector2dUnfiltered.getX());
        this.y.update(vector2dUnfiltered.getY());
    }

    public void update(FrameVector2D vector2dUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)vector2dUnfiltered);
        this.x.update(vector2dUnfiltered.getX());
        this.y.update(vector2dUnfiltered.getY());
    }

    public void reset() {
        this.x.reset();
        this.y.reset();
    }
}

