/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class BacklashCompensatingVelocityYoVariable
extends YoDouble
implements ProcessingYoVariable {
    private final double dt;
    private final YoDouble alphaVariable;
    private final YoDouble position;
    private final YoDouble lastPosition;
    private final YoBoolean hasBeenCalled;
    private final YoEnum<BacklashState> backlashState;
    private final YoDouble slopTime;
    private final YoDouble timeInState;

    public BacklashCompensatingVelocityYoVariable(String name, String description, YoDouble alphaVariable, YoDouble positionVariable, double dt, YoDouble slopTime, YoRegistry registry) {
        super(name, description, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.backlashState = new YoEnum(name + "BacklashState", registry, BacklashState.class, true);
        this.backlashState.set(null);
        this.timeInState = new YoDouble(name + "TimeInState", registry);
        this.position = positionVariable;
        this.alphaVariable = alphaVariable;
        this.slopTime = slopTime;
        this.dt = dt;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.reset();
    }

    public BacklashCompensatingVelocityYoVariable(String name, String description, YoDouble alphaVariable, double dt, YoDouble slopTime, YoRegistry registry) {
        super(name, description, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.backlashState = new YoEnum(name + "BacklashState", registry, BacklashState.class, true);
        this.backlashState.set(null);
        this.timeInState = new YoDouble(name + "timeInState", registry);
        this.position = null;
        this.alphaVariable = alphaVariable;
        this.slopTime = slopTime;
        this.dt = dt;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.reset();
    }

    @Override
    public void reset() {
        this.hasBeenCalled.set(false);
        this.backlashState.set(null);
    }

    @Override
    public void update() {
        if (this.position == null) {
            throw new NullPointerException("YoFilteredVelocityVariable must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position.getDoubleValue());
    }

    public void update(double currentPosition) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.lastPosition.set(currentPosition);
            this.set(0.0);
        }
        this.timeInState.add(this.dt);
        boolean sloppy = false;
        double difference = currentPosition - this.lastPosition.getDoubleValue();
        if (this.backlashState.getEnumValue() == null) {
            if (difference > 0.0) {
                this.backlashState.set((Enum)BacklashState.FORWARD_OK);
            } else if (difference < 0.0) {
                this.backlashState.set((Enum)BacklashState.BACKWARD_OK);
            }
        } else {
            switch ((BacklashState)this.backlashState.getEnumValue()) {
                case BACKWARD_OK: {
                    if (!(difference > 0.0)) break;
                    this.backlashState.set((Enum)BacklashState.FORWARD_SLOP);
                    sloppy = true;
                    this.timeInState.set(0.0);
                    break;
                }
                case FORWARD_OK: {
                    if (!(difference < 0.0)) break;
                    this.backlashState.set((Enum)BacklashState.BACKWARD_SLOP);
                    sloppy = true;
                    this.timeInState.set(0.0);
                    break;
                }
                case BACKWARD_SLOP: {
                    sloppy = true;
                    if (difference > 0.0) {
                        this.backlashState.set((Enum)BacklashState.FORWARD_SLOP);
                        sloppy = true;
                        this.timeInState.set(0.0);
                        break;
                    }
                    if (!(this.timeInState.getDoubleValue() > this.slopTime.getDoubleValue())) break;
                    this.backlashState.set((Enum)BacklashState.BACKWARD_OK);
                    sloppy = false;
                    this.timeInState.set(0.0);
                    break;
                }
                case FORWARD_SLOP: {
                    sloppy = true;
                    if (difference < 0.0) {
                        this.backlashState.set((Enum)BacklashState.BACKWARD_SLOP);
                        sloppy = true;
                        this.timeInState.set(0.0);
                        break;
                    }
                    if (!(this.timeInState.getDoubleValue() > this.slopTime.getDoubleValue())) break;
                    this.backlashState.set((Enum)BacklashState.FORWARD_OK);
                    sloppy = false;
                    this.timeInState.set(0.0);
                }
            }
        }
        if (sloppy) {
            double percent = this.timeInState.getDoubleValue() / this.slopTime.getDoubleValue();
            if (Double.isNaN(percent = MathTools.clamp((double)percent, (double)0.0, (double)1.0))) {
                percent = 1.0;
            }
            double scaleFactor = percent;
            difference = scaleFactor * difference;
        }
        this.updateUsingDifference(difference);
        this.lastPosition.set(currentPosition);
    }

    private void updateUsingDifference(double difference) {
        double previousFilteredDerivative = this.getDoubleValue();
        double currentRawDerivative = difference / this.dt;
        double alpha = this.alphaVariable.getDoubleValue();
        this.set(alpha * previousFilteredDerivative + (1.0 - alpha) * currentRawDerivative);
    }

    public void setAlpha(double alpha) {
        this.alphaVariable.set(alpha);
    }

    public void setSlopTime(double slopTime) {
        this.slopTime.set(slopTime);
    }

    private static enum BacklashState {
        BACKWARD_OK,
        FORWARD_OK,
        BACKWARD_SLOP,
        FORWARD_SLOP;

    }
}

