/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class AverageYoDouble
extends YoDouble {
    private final YoInteger sampleSize;
    private final DoubleProvider dataSource;

    public AverageYoDouble(String name, YoRegistry registry) {
        this(name, null, registry);
    }

    public AverageYoDouble(String name, DoubleProvider dataSource, YoRegistry registry) {
        super(name, registry);
        this.dataSource = dataSource;
        this.sampleSize = new YoInteger(name + "SampleSize", registry);
    }

    public void update() {
        if (this.dataSource == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null dataSource variable to call update(), otherwise use update(double)");
        }
        this.update(this.dataSource.getValue());
    }

    public void update(double dataSource) {
        this.sampleSize.increment();
        this.add((dataSource - this.getValue()) / (double)this.sampleSize.getValue());
    }

    public void reset() {
        this.sampleSize.set(0);
    }

    public int getSampleSize() {
        return this.sampleSize.getValue();
    }
}

