/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class YoSignalDerivative {
    private static final double DEFAULT_TOLERANCE = Double.MIN_VALUE;
    private final String name;
    private YoEnum<DifferentiationMode> differentiationMode;
    private YoDouble previousSignal;
    private YoDouble previousDerivative;
    private YoDouble previousTime;
    private YoDouble timeAtLastSignalChange;
    private YoDouble tolerance;
    private YoDouble lastSignalChange;

    public YoSignalDerivative(String name, YoRegistry registry) {
        this.name = name;
        this.differentiationMode = new YoEnum(name + "_differentiationMode", registry, DifferentiationMode.class);
        this.previousDerivative = new YoDouble(name + "_previousDerivative", registry);
        this.previousSignal = new YoDouble(name + "_previousSignal", registry);
        this.timeAtLastSignalChange = new YoDouble(name + "_timeAtLastSignalChange", registry);
        this.previousTime = new YoDouble(name + "_previousTime", registry);
        this.tolerance = new YoDouble(name + "_tolerance", registry);
        this.lastSignalChange = new YoDouble(name + "_lastSignalChange", registry);
        this.tolerance.set(Double.MIN_VALUE);
        this.resetToZero();
    }

    public void setDifferentiationMode(DifferentiationMode mode) {
        this.differentiationMode.set((Enum)mode);
    }

    public void initialize(DifferentiationMode mode, double initialSignal, double initialTime, double initialDerivative) {
        this.initialize(mode, Double.MIN_VALUE, initialSignal, initialTime, initialDerivative);
    }

    public void initialize(DifferentiationMode mode, double tolerance, double initialSignal, double initialTime, double initialDerivative) {
        this.setDifferentiationMode(mode);
        this.previousDerivative.set(initialDerivative);
        this.previousSignal.set(initialSignal);
        this.previousTime.set(initialTime);
        this.lastSignalChange.set(initialSignal);
        this.timeAtLastSignalChange.set(initialTime);
        this.tolerance.set(tolerance);
    }

    public double getDerivative(double signal, double time) {
        double ret = 0.0;
        switch ((DifferentiationMode)this.differentiationMode.getEnumValue()) {
            case USING_DT: {
                ret = (signal - this.previousSignal.getDoubleValue()) / (time - this.previousTime.getDoubleValue());
                break;
            }
            case ON_SIGNAL_CHANGE: {
                if (Math.abs(signal - this.lastSignalChange.getDoubleValue()) < this.tolerance.getDoubleValue()) {
                    ret = this.previousDerivative.getDoubleValue();
                    break;
                }
                ret = (signal - this.lastSignalChange.getDoubleValue()) / (time - this.timeAtLastSignalChange.getDoubleValue());
                this.timeAtLastSignalChange.set(time);
                this.lastSignalChange.set(signal);
            }
        }
        this.previousSignal.set(signal);
        this.previousTime.set(time);
        this.previousDerivative.set(ret);
        return ret;
    }

    public void resetToZero() {
        this.differentiationMode.set((Enum)DifferentiationMode.USING_DT);
        this.previousDerivative.set(0.0);
        this.previousSignal.set(0.0);
        this.timeAtLastSignalChange.set(0.0);
        this.previousTime.set(0.0);
        this.lastSignalChange.set(0.0);
    }

    public DifferentiationMode getDifferentiationMode() {
        return (DifferentiationMode)this.differentiationMode.getEnumValue();
    }

    public String getName() {
        return this.name;
    }

    public static enum DifferentiationMode {
        ON_SIGNAL_CHANGE,
        USING_DT;

    }
}

