/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoAverager {
    private final YoDouble average;
    private final YoInteger nUpdates;

    public YoAverager(String prefix, YoRegistry registry) {
        this.average = new YoDouble(prefix + "Average", registry);
        this.nUpdates = new YoInteger(prefix + "AverageNUpdates", registry);
    }

    public void update(double input) {
        int nUpdatesOld = this.nUpdates.getIntegerValue();
        this.nUpdates.increment();
        int nUpdatesNew = this.nUpdates.getIntegerValue();
        double ratio = (double)nUpdatesOld / (double)nUpdatesNew;
        this.average.set(this.average.getDoubleValue() * ratio + input / (double)this.nUpdates.getIntegerValue());
    }

    public double val() {
        return this.average.getDoubleValue();
    }

    public void reset() {
        this.nUpdates.set(0);
    }

    public YoDouble getAverageYoVariable() {
        return this.average;
    }
}

