/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import java.util.List;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.math.RootsOfUnity;

public class FastFourierTransform {
    private static final double logTwo = Math.log(2.0);
    public static final FastFourierTransform fft = new FastFourierTransform(8);
    private int maxNumberOfCoefficients;
    private int logMaxNumberOfCoefficients;
    private int numberOfCoefficients;
    private List<ComplexNumber> rootsOfUnity;
    private ComplexNumber[] coefficients;
    private ComplexNumber[] transformedCoeffs;
    private ComplexNumber tempComplex1 = new ComplexNumber();
    private ComplexNumber tempComplex2 = new ComplexNumber();
    private ComplexNumber tempComplex = new ComplexNumber();

    public static FastFourierTransform getFourierTransformer() {
        return fft;
    }

    public FastFourierTransform(int maxNumberOfCoefficients) {
        this.logMaxNumberOfCoefficients = (int)Math.ceil(Math.log(maxNumberOfCoefficients) / logTwo);
        this.maxNumberOfCoefficients = (int)Math.pow(2.0, this.logMaxNumberOfCoefficients);
        this.rootsOfUnity = RootsOfUnity.getRootsOfUnity(this.maxNumberOfCoefficients);
        this.coefficients = new ComplexNumber[this.maxNumberOfCoefficients];
        this.transformedCoeffs = new ComplexNumber[this.maxNumberOfCoefficients];
        for (int i = 0; i < this.maxNumberOfCoefficients; ++i) {
            this.coefficients[i] = new ComplexNumber();
            this.transformedCoeffs[i] = new ComplexNumber();
        }
    }

    public void setCoefficients(ComplexNumber[] coefficients) {
        int index;
        this.numberOfCoefficients = coefficients.length;
        if (this.numberOfCoefficients > this.maxNumberOfCoefficients) {
            throw new RuntimeException("Insufficient number of coefficients for FFT transform, max: " + this.maxNumberOfCoefficients + ", provided: " + this.numberOfCoefficients);
        }
        for (index = 0; index < this.numberOfCoefficients; ++index) {
            this.coefficients[index].set(coefficients[index]);
        }
        while (index < this.maxNumberOfCoefficients) {
            this.coefficients[index].setToPurelyReal(0.0);
            ++index;
        }
    }

    public void setCoefficients(double[] coefficients) {
        int index;
        this.numberOfCoefficients = coefficients.length;
        if (this.numberOfCoefficients > this.maxNumberOfCoefficients) {
            throw new RuntimeException("Insufficient number of coefficients for FFT transform, max: " + this.maxNumberOfCoefficients + ", provided: " + this.numberOfCoefficients);
        }
        for (index = 0; index < this.numberOfCoefficients; ++index) {
            this.coefficients[index].setToPurelyReal(coefficients[index]);
        }
        while (index < this.maxNumberOfCoefficients) {
            this.coefficients[index].setToPurelyReal(0.0);
            ++index;
        }
    }

    public void setCoefficients(double[] coefficients, int numberOfCoefficientsToUse) {
        int index;
        this.numberOfCoefficients = numberOfCoefficientsToUse;
        if (numberOfCoefficientsToUse > this.maxNumberOfCoefficients) {
            throw new RuntimeException("Insufficient number of coefficients for FFT transform, max: " + this.maxNumberOfCoefficients + ", provided: " + numberOfCoefficientsToUse);
        }
        for (index = 0; index < numberOfCoefficientsToUse; ++index) {
            this.coefficients[index].setToPurelyReal(coefficients[index]);
        }
        while (index < this.maxNumberOfCoefficients) {
            this.coefficients[index].setToPurelyReal(0.0);
            ++index;
        }
    }

    public ComplexNumber[] getForwardTransform() {
        this.transform(false);
        return this.transformedCoeffs;
    }

    public ComplexNumber[] getInverseTransform() {
        this.transform(true);
        return this.transformedCoeffs;
    }

    private void transform(boolean inverse) {
        int i;
        this.bitReverseCopy(this.transformedCoeffs, this.coefficients);
        int m = 1;
        for (i = 1; i <= this.logMaxNumberOfCoefficients; ++i) {
            int half_m = m;
            m <<= 1;
            this.tempComplex.setToPurelyReal(1.0);
            for (int j = 0; j < half_m; ++j) {
                for (int k = j; k < this.maxNumberOfCoefficients - 1; k += m) {
                    this.tempComplex1.timesAndStore(this.tempComplex, this.transformedCoeffs[k + half_m]);
                    this.tempComplex2.set(this.transformedCoeffs[k]);
                    this.transformedCoeffs[k].plusAndStore(this.tempComplex1, this.tempComplex2);
                    this.transformedCoeffs[k + half_m].minusAndStore(this.tempComplex2, this.tempComplex1);
                }
                if (!inverse) {
                    this.tempComplex.timesAndStore(this.rootsOfUnity.get(this.maxNumberOfCoefficients - this.maxNumberOfCoefficients / m));
                    continue;
                }
                this.tempComplex.timesAndStore(this.rootsOfUnity.get(this.maxNumberOfCoefficients / m));
            }
        }
        if (inverse) {
            for (i = 0; i < this.transformedCoeffs.length; ++i) {
                this.transformedCoeffs[i].scale(1.0 / (double)this.maxNumberOfCoefficients);
            }
        }
    }

    private void bitReverseCopy(ComplexNumber[] arrayToPack, ComplexNumber[] arrayToCopy) {
        int temp = (int)(Math.log(arrayToCopy.length) / logTwo);
        for (int i = 0; i < arrayToCopy.length; ++i) {
            arrayToPack[i].set(arrayToCopy[this.bitReverse(i, temp)]);
        }
    }

    public int bitReverse(int a, int numberOfBits) {
        int temp = 0;
        while (numberOfBits > 0) {
            temp <<= 1;
            --numberOfBits;
            temp += a % 2;
            a /= 2;
        }
        return temp;
    }

    private void clearTransformed() {
        for (int i = 0; i < this.maxNumberOfCoefficients; ++i) {
            this.transformedCoeffs[i].set(0.0, 0.0);
        }
    }

    private void clearInput() {
        for (int i = 0; i < this.numberOfCoefficients; ++i) {
            this.coefficients[i].set(0.0, 0.0);
        }
    }

    public void clear() {
        this.clearTransformed();
        this.clearInput();
    }

    public int getMaxNumberOfCoefficients() {
        return this.maxNumberOfCoefficients;
    }

    public List<ComplexNumber> getRootsOfUnity() {
        return this.rootsOfUnity;
    }
}

