/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.cdreSolvers;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.linearAlgebra.careSolvers.CARETools;
import us.ihmc.robotics.linearAlgebra.careSolvers.MatrixChecking;
import us.ihmc.robotics.linearAlgebra.cdreSolvers.CDRESolver;

public abstract class AbstractCDRESolver
implements CDRESolver {
    private final DMatrixRMaj Rinv = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj tempMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj RinvSTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj SRinvSTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj RinvSTransposeC = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj AHat = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj QHat = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj BTranspose = new DMatrixRMaj(0, 0);
    protected int n;
    protected final DMatrixRMaj M = new DMatrixRMaj(0, 0);
    protected final DMatrixRMaj A = new DMatrixRMaj(0, 0);
    protected final DMatrixRMaj E = new DMatrixRMaj(0, 0);
    protected final DMatrixRMaj Q = new DMatrixRMaj(0, 0);
    protected boolean hasE = false;
    protected final DMatrixRMaj P = new DMatrixRMaj(0, 0);
    protected boolean isUpToDate = false;

    @Override
    public void setMatrices(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj C, DMatrixRMaj E, DMatrixRMaj Q, DMatrixRMaj R, DMatrixRMaj S) {
        DMatrixRMaj QLocal;
        DMatrixRMaj ALocal;
        int m = this.Rinv.getNumRows();
        int n = B.getNumRows();
        this.BTranspose.set((DMatrixD1)B);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.BTranspose);
        this.Rinv.reshape(m, m);
        this.M.reshape(n, n);
        CARETools.computeM(this.BTranspose, R, this.Rinv, this.M);
        if (S == null) {
            ALocal = A;
            if (C == null) {
                QLocal = Q;
            } else {
                this.QHat.reshape(C.getNumCols(), C.getNumCols());
                NativeCommonOps.multQuad((DMatrix1Row)C, (DMatrix1Row)Q, (DMatrix1Row)this.QHat);
                QLocal = this.QHat;
            }
        } else {
            this.AHat.set((DMatrixD1)A);
            this.RinvSTranspose.reshape(m, S.getNumCols());
            CommonOps_DDRM.multTransB((DMatrix1Row)this.Rinv, (DMatrix1Row)S, (DMatrix1Row)this.RinvSTranspose);
            this.SRinvSTranspose.reshape(S.getNumRows(), S.getNumRows());
            CommonOps_DDRM.mult((DMatrix1Row)S, (DMatrix1Row)this.RinvSTranspose, (DMatrix1Row)this.SRinvSTranspose);
            this.tempMatrix.set((DMatrixD1)Q);
            CommonOps_DDRM.subtractEquals((DMatrixD1)this.tempMatrix, (DMatrixD1)this.SRinvSTranspose);
            if (C != null) {
                this.QHat.reshape(C.getNumCols(), C.getNumCols());
                this.RinvSTransposeC.reshape(this.RinvSTranspose.getNumRows(), C.getNumCols());
                CommonOps_DDRM.mult((DMatrix1Row)this.RinvSTranspose, (DMatrix1Row)C, (DMatrix1Row)this.RinvSTransposeC);
                NativeCommonOps.multQuad((DMatrix1Row)C, (DMatrix1Row)this.tempMatrix, (DMatrix1Row)this.QHat);
            } else {
                this.RinvSTransposeC.set((DMatrixD1)this.RinvSTranspose);
                this.QHat.set((DMatrixD1)this.tempMatrix);
            }
            CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)B, (DMatrix1Row)this.RinvSTransposeC, (DMatrix1Row)this.AHat);
            ALocal = this.AHat;
            QLocal = this.QHat;
        }
        this.setMatrices(ALocal, E, this.M, QLocal);
    }

    @Override
    public void setMatrices(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj E, DMatrixRMaj Q, DMatrixRMaj R) {
        int m = this.Rinv.getNumRows();
        int n = B.getNumRows();
        this.Rinv.reshape(m, m);
        this.BTranspose.set((DMatrixD1)B);
        CommonOps_DDRM.transpose((DMatrixRMaj)this.BTranspose);
        this.M.reshape(n, n);
        CARETools.computeM(this.BTranspose, R, this.Rinv, this.M);
        this.setMatrices(A, E, this.M, Q);
    }

    @Override
    public void setMatrices(DMatrixRMaj A, DMatrixRMaj E, DMatrixRMaj M, DMatrixRMaj Q) {
        MatrixChecking.assertMultiplicationCompatible(A, Q);
        this.n = A.getNumRows();
        this.A.set((DMatrixD1)A);
        if (E != null) {
            this.E.set((DMatrixD1)E);
            this.hasE = true;
        } else {
            this.hasE = false;
        }
        this.M.set((DMatrixD1)M);
        this.Q.set((DMatrixD1)Q);
        this.isUpToDate = false;
    }
}

