/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.interaction;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCapsule3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameCylinder3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameEllipsoid3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePointShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameSphere3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.interaction.BoxRayIntersection;
import us.ihmc.robotics.interaction.CapsuleRayIntersection;
import us.ihmc.robotics.interaction.CylinderRayIntersection;
import us.ihmc.robotics.interaction.EllipsoidRayIntersection;
import us.ihmc.robotics.interaction.SphereRayIntersection;
import us.ihmc.robotics.physics.Collidable;

public class MouseCollidable {
    private final FrameShape3DReadOnly shape;
    private SphereRayIntersection sphereRayIntersection;
    private CapsuleRayIntersection capsuleIntersection;
    private CylinderRayIntersection cylinderRayIntersection;
    private EllipsoidRayIntersection ellipsoidRayIntersection;
    private BoxRayIntersection boxRayIntersection;

    public MouseCollidable(Collidable collidable) {
        this(collidable.getShape());
    }

    public MouseCollidable(FrameShape3DReadOnly shape) {
        this.shape = shape;
        if (shape instanceof FrameSphere3DReadOnly) {
            this.sphereRayIntersection = new SphereRayIntersection();
        } else if (shape instanceof FrameCapsule3DReadOnly) {
            this.capsuleIntersection = new CapsuleRayIntersection();
        } else if (shape instanceof FrameBox3DReadOnly) {
            this.boxRayIntersection = new BoxRayIntersection();
        } else if (!(shape instanceof FramePointShape3DReadOnly)) {
            if (shape instanceof FrameCylinder3DReadOnly) {
                this.cylinderRayIntersection = new CylinderRayIntersection();
            } else if (shape instanceof FrameEllipsoid3DReadOnly) {
                this.ellipsoidRayIntersection = new EllipsoidRayIntersection();
            } else {
                LogTools.warn((String)"Shape not handled: {}", (Object)shape);
            }
        }
    }

    public double collide(Line3DReadOnly pickRayInWorld, ReferenceFrame shapePoseFrame) {
        FrameShape3DReadOnly frameShape3DReadOnly = this.shape;
        if (frameShape3DReadOnly instanceof Sphere3DReadOnly) {
            Sphere3DReadOnly sphere = (Sphere3DReadOnly)frameShape3DReadOnly;
            this.sphereRayIntersection.update(sphere.getRadius(), sphere.getPosition(), shapePoseFrame);
            if (this.sphereRayIntersection.intersect(pickRayInWorld)) {
                return pickRayInWorld.getPoint().distance(this.sphereRayIntersection.getFirstIntersectionToPack());
            }
        } else {
            frameShape3DReadOnly = this.shape;
            if (frameShape3DReadOnly instanceof Capsule3DReadOnly) {
                Capsule3DReadOnly capsule = (Capsule3DReadOnly)frameShape3DReadOnly;
                UnitVector3DReadOnly axis = capsule.getAxis();
                Point3DReadOnly position = capsule.getPosition();
                double length = capsule.getLength();
                double radius = capsule.getRadius();
                this.capsuleIntersection.update(radius, length, position, axis, shapePoseFrame.getParent());
                if (this.capsuleIntersection.intersect(pickRayInWorld)) {
                    return this.capsuleIntersection.getDistanceToCollision(pickRayInWorld);
                }
            } else {
                frameShape3DReadOnly = this.shape;
                if (frameShape3DReadOnly instanceof Box3DReadOnly) {
                    Box3DReadOnly box = (Box3DReadOnly)frameShape3DReadOnly;
                    if (this.boxRayIntersection.intersect(box.getSizeX(), box.getSizeY(), box.getSizeZ(), shapePoseFrame.getTransformToRoot(), pickRayInWorld)) {
                        return this.boxRayIntersection.getFirstIntersectionToPack().distance(pickRayInWorld.getPoint());
                    }
                } else {
                    frameShape3DReadOnly = this.shape;
                    if (frameShape3DReadOnly instanceof PointShape3DReadOnly) {
                        PointShape3DReadOnly pointShape = (PointShape3DReadOnly)frameShape3DReadOnly;
                    } else {
                        frameShape3DReadOnly = this.shape;
                        if (frameShape3DReadOnly instanceof Cylinder3DReadOnly) {
                            Cylinder3DReadOnly cylinder = (Cylinder3DReadOnly)frameShape3DReadOnly;
                            this.cylinderRayIntersection.update(cylinder.getLength(), cylinder.getRadius(), cylinder.getPosition(), cylinder.getAxis(), shapePoseFrame.getParent());
                            return this.cylinderRayIntersection.intersect(pickRayInWorld);
                        }
                        frameShape3DReadOnly = this.shape;
                        if (frameShape3DReadOnly instanceof Ellipsoid3DReadOnly) {
                            Ellipsoid3DReadOnly ellipsoid = (Ellipsoid3DReadOnly)frameShape3DReadOnly;
                            this.ellipsoidRayIntersection.update(ellipsoid.getRadiusX(), ellipsoid.getRadiusY(), ellipsoid.getRadiusZ(), ellipsoid.getPosition(), (Orientation3DReadOnly)ellipsoid.getOrientation(), shapePoseFrame.getParent());
                            if (this.ellipsoidRayIntersection.intersect(pickRayInWorld)) {
                                return this.ellipsoidRayIntersection.getFirstIntersectionToPack().distance(pickRayInWorld.getPoint());
                            }
                        } else {
                            LogTools.warn((String)"Shape not handled: {}", (Object)this.shape);
                        }
                    }
                }
            }
        }
        return Double.NaN;
    }
}

