/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.interaction;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FrameCylinder3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;

public class CylinderRayIntersection {
    private final RigidBodyTransform cylinderToWorldTransform = new RigidBodyTransform();
    private final ReferenceFrame cylinderFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent(ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.cylinderToWorldTransform);
    private final FrameCylinder3D cylinder = new FrameCylinder3D();
    private final Point3D firstIntersectionToPack = new Point3D();
    private final Point3D secondIntersectionToPack = new Point3D();
    private boolean intersects = false;

    public void update(double length, double radius, Point3DReadOnly position, UnitVector3DReadOnly axis, ReferenceFrame referenceFrame) {
        referenceFrame.getTransformToDesiredFrame(this.cylinderToWorldTransform, ReferenceFrame.getWorldFrame());
        this.cylinderFrame.update();
        this.cylinder.setToZero(this.cylinderFrame);
        this.cylinder.setSize(length, radius);
        this.cylinder.getPosition().set((Tuple3DReadOnly)position);
        this.cylinder.getAxis().set(axis);
    }

    public void update(double length, double radius, double zOffset, RigidBodyTransformReadOnly transformToWorld) {
        this.cylinderToWorldTransform.set(transformToWorld);
        this.cylinderFrame.update();
        this.cylinder.setToZero(this.cylinderFrame);
        this.cylinder.setSize(length, radius);
        this.cylinder.getPosition().addZ(zOffset);
    }

    public double intersect(Line3DReadOnly pickRay) {
        this.cylinder.changeFrame(ReferenceFrame.getWorldFrame());
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)this.cylinder.getLength(), (double)this.cylinder.getRadius(), (Point3DReadOnly)this.cylinder.getPosition(), (Vector3DReadOnly)this.cylinder.getAxis(), (Point3DReadOnly)pickRay.getPoint(), (Vector3DReadOnly)pickRay.getDirection(), (Point3DBasics)this.firstIntersectionToPack, (Point3DBasics)this.secondIntersectionToPack);
        this.intersects = numberOfIntersections == 2;
        return this.intersects ? this.firstIntersectionToPack.distance(pickRay.getPoint()) : Double.NaN;
    }

    public Point3DReadOnly getClosestIntersection() {
        return this.firstIntersectionToPack;
    }

    public Cylinder3DReadOnly getCylinder() {
        return this.cylinder;
    }

    public boolean getIntersects() {
        return this.intersects;
    }
}

