/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.hyperCubeTree.LowPassTimingReporter;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;
import us.ihmc.robotics.hyperCubeTree.ResolutionProvider;

public class SphericalLinearResolutionProvider
implements ResolutionProvider {
    private static final boolean DEBUG = false;
    private final FramePoint3D center;
    private final FramePoint3D centerInWorldTemp;
    private final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final double[] tempCenter = new double[3];
    private final OneDimensionalBounds linearRegion;
    private final double centerResolution;
    private final double exteriorResolution;
    private final double outerRadiusSquared;
    private final double innerRadiusSquared;
    private final LowPassTimingReporter timer = new LowPassTimingReporter(5);

    public SphericalLinearResolutionProvider(FramePoint3D center, double radius1, double innerResolution, double radius2, double outerResolution) {
        this(center, new OneDimensionalBounds(Math.abs(radius1), Math.abs(radius2)), innerResolution, outerResolution);
    }

    public SphericalLinearResolutionProvider(FramePoint3D center, OneDimensionalBounds bounds, double innerResolution, double exteriorResolution) {
        this.center = center;
        this.centerInWorldTemp = new FramePoint3D((FrameTuple3DReadOnly)center);
        this.centerInWorldTemp.changeFrame(this.worldFrame);
        this.linearRegion = bounds;
        this.centerResolution = innerResolution;
        this.exteriorResolution = exteriorResolution;
        this.outerRadiusSquared = this.linearRegion.max() * this.linearRegion.max();
        this.innerRadiusSquared = this.linearRegion.min() * this.linearRegion.min();
    }

    @Override
    public double getResolution(double[] location) {
        this.timer.startTime();
        double distanceSquared = 0.0;
        this.centerInWorldTemp.setIncludingFrame((FrameTuple3DReadOnly)this.center);
        this.centerInWorldTemp.changeFrame(this.worldFrame);
        this.centerInWorldTemp.get(this.tempCenter);
        for (int i = 0; i < location.length; ++i) {
            double difference = location[i] - this.tempCenter[i];
            distanceSquared += difference * difference;
        }
        if (this.outerRadiusSquared <= distanceSquared) {
            return this.exteriorResolution;
        }
        if (this.innerRadiusSquared >= distanceSquared) {
            return this.centerResolution;
        }
        double distance = Math.sqrt(distanceSquared);
        double resolution = this.centerResolution + (this.exteriorResolution - this.centerResolution) * this.linearRegion.unScale(distance);
        this.timer.endTime();
        return resolution;
    }

    @Override
    public double getMinResolution() {
        return this.centerResolution;
    }
}

