/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import us.ihmc.robotics.hyperCubeTree.DimensionalityMismatchException;

public class OneDimensionalBounds {
    double midpoint = Double.NaN;
    final double min;
    final double max;

    public OneDimensionalBounds(Double bound1, Double bound2) {
        this.min = bound2 >= bound1 ? bound1 : bound2;
        this.max = bound2 >= bound1 ? bound2 : bound1;
        if (Double.isNaN(bound1) || Double.isNaN(bound2)) {
            throw new RuntimeException("illegal Bounds " + bound1 + " and " + bound2);
        }
    }

    public double max() {
        return this.max;
    }

    public double min() {
        return this.min;
    }

    public double midpoint() {
        if (this.isInfinite()) {
            throw new RuntimeException("It is impossible to bisect an infinite range.");
        }
        if (Double.isNaN(this.midpoint)) {
            this.midpoint = (this.min() + this.max()) * 0.5;
        }
        return this.midpoint;
    }

    public double size() {
        return this.max - this.min;
    }

    public boolean contains(double testValue) {
        return testValue <= this.max && testValue >= this.min;
    }

    public boolean maxSide(double testValue) {
        return testValue >= this.midpoint();
    }

    public OneDimensionalBounds subdivide(boolean maxSide) {
        if (maxSide) {
            return new OneDimensionalBounds(this.midpoint(), this.max);
        }
        return new OneDimensionalBounds(this.min, this.midpoint());
    }

    public boolean intersects(OneDimensionalBounds other) {
        return other.min <= this.max && this.min <= other.max;
    }

    public boolean isSupersetOf(OneDimensionalBounds other) {
        return other.min >= this.min && this.max >= other.max;
    }

    public boolean isSubsetOf(OneDimensionalBounds other) {
        return other.min <= this.min && this.max <= other.max;
    }

    public OneDimensionalBounds intersectionWith(OneDimensionalBounds other) {
        if (this.intersects(other)) {
            return new OneDimensionalBounds(Math.max(this.min(), other.min()), Math.min(this.max(), other.max()));
        }
        return null;
    }

    public static OneDimensionalBounds unbounded() {
        return new OneDimensionalBounds(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.max) || Double.isInfinite(this.min);
    }

    public double scale(double valueBetweenZeroAndOne) {
        return this.min() + this.size() * valueBetweenZeroAndOne;
    }

    public double unScale(double value) {
        return (value - this.min()) / this.size();
    }

    public String toString() {
        if (this.isInfinite()) {
            return "infinite range " + (Double.isInfinite(this.min) ? "(" : "[") + this.min + ", " + this.max + (Double.isInfinite(this.max) ? ")" : "]");
        }
        return "finite, inclusive range [" + this.min + ", " + this.max + "]";
    }

    public static OneDimensionalBounds[] intersection(OneDimensionalBounds[] boundsA, OneDimensionalBounds[] boundsB) {
        if (boundsB.length != boundsA.length) {
            throw new DimensionalityMismatchException();
        }
        OneDimensionalBounds[] intersection = new OneDimensionalBounds[boundsA.length];
        for (int i = 0; i < boundsA.length; ++i) {
            intersection[i] = boundsA[i].intersectionWith(boundsB[i]);
            if (null != intersection[i]) continue;
            return null;
        }
        return intersection;
    }
}

