/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import java.util.List;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryFactories;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.Face3D;
import us.ihmc.euclid.shape.convexPolytope.HalfEdge3D;
import us.ihmc.euclid.shape.convexPolytope.Vertex3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DPoseBasics;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.geometry.shapes.STPShape3DTools;
import us.ihmc.robotics.geometry.shapes.interfaces.STPConvexPolytope3DReadOnly;
import us.ihmc.robotics.geometry.shapes.interfaces.STPShape3DBasics;

public class STPConvexPolytope3D
implements STPConvexPolytope3DReadOnly,
STPShape3DBasics {
    private double minimumMargin;
    private double maximumMargin;
    private double largeRadius;
    private double smallRadius;
    private final ConvexPolytope3D rawConvexPolytope3D;
    private final BoundingBox3DReadOnly boundingBox;
    private final STPShape3DTools.STPConvexPolytope3DSupportingVertexCalculator supportingVertexCalculator = new STPShape3DTools.STPConvexPolytope3DSupportingVertexCalculator();
    private boolean stpRadiiDirty = true;

    public STPConvexPolytope3D() {
        this(1.0E-10);
    }

    public STPConvexPolytope3D(double constructionEpsilon) {
        this.rawConvexPolytope3D = new ConvexPolytope3D(constructionEpsilon);
        Point3DBasics rawMinPoint = this.rawConvexPolytope3D.getBoundingBox().getMinPoint();
        Point3DBasics rawMaxPoint = this.rawConvexPolytope3D.getBoundingBox().getMaxPoint();
        Point3DReadOnly minPoint = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> this.lambda$new$0((Point3DReadOnly)rawMinPoint), () -> this.lambda$new$1((Point3DReadOnly)rawMinPoint), () -> this.lambda$new$2((Point3DReadOnly)rawMinPoint));
        Point3DReadOnly maxPoint = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> this.lambda$new$3((Point3DReadOnly)rawMaxPoint), () -> this.lambda$new$4((Point3DReadOnly)rawMaxPoint), () -> this.lambda$new$5((Point3DReadOnly)rawMaxPoint));
        this.boundingBox = EuclidGeometryFactories.newLinkedBoundingBox3DReadOnly((Point3DReadOnly)minPoint, (Point3DReadOnly)maxPoint);
    }

    public STPConvexPolytope3D(Vertex3DSupplier vertex3DSupplier) {
        this();
        this.addVertices(vertex3DSupplier);
    }

    public STPConvexPolytope3D(Vertex3DSupplier vertex3DSupplier, double constructionEpsilon) {
        this(constructionEpsilon);
        this.addVertices(vertex3DSupplier);
    }

    public STPConvexPolytope3D(ConvexPolytope3DReadOnly other) {
        this(other.getConstructionEpsilon());
        this.set(other);
    }

    public STPConvexPolytope3D(STPConvexPolytope3DReadOnly other) {
        this(other.getConstructionEpsilon());
        this.set(other);
    }

    public void set(ConvexPolytope3DReadOnly other) {
        this.rawConvexPolytope3D.set(other);
        this.stpRadiiDirty = true;
    }

    public void set(STPConvexPolytope3DReadOnly other) {
        this.rawConvexPolytope3D.set((ConvexPolytope3DReadOnly)other);
        this.minimumMargin = other.getMinimumMargin();
        this.maximumMargin = other.getMaximumMargin();
        this.stpRadiiDirty = true;
    }

    public void setToNaN() {
        this.rawConvexPolytope3D.setToNaN();
        this.stpRadiiDirty = true;
    }

    public void setToZero() {
        this.rawConvexPolytope3D.setToZero();
        this.stpRadiiDirty = true;
    }

    public boolean addVertex(Point3DReadOnly vertexToAdd) {
        return this.addVertices(Vertex3DSupplier.asVertex3DSupplier((Point3DReadOnly[])new Point3DReadOnly[]{vertexToAdd}));
    }

    public boolean addVertices(Vertex3DSupplier vertex3DSupplier) {
        boolean wasAdded = this.rawConvexPolytope3D.addVertices(vertex3DSupplier);
        if (wasAdded) {
            this.stpRadiiDirty = true;
        }
        return wasAdded;
    }

    @Override
    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    @Override
    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public double getSmallRadius() {
        this.updateRadii();
        return this.smallRadius;
    }

    @Override
    public double getLargeRadius() {
        this.updateRadii();
        return this.largeRadius;
    }

    @Override
    public void setMargins(double minimumMargin, double maximumMargin) {
        if (maximumMargin <= minimumMargin) {
            throw new IllegalArgumentException("The maximum margin has to be strictly greater that the minimum margin, max margin: " + maximumMargin + ", min margin: " + minimumMargin);
        }
        this.minimumMargin = minimumMargin;
        this.maximumMargin = maximumMargin;
        this.stpRadiiDirty = true;
    }

    protected void updateRadii() {
        if (!this.stpRadiiDirty) {
            return;
        }
        this.stpRadiiDirty = false;
        if (this.minimumMargin == 0.0 && this.maximumMargin == 0.0) {
            this.smallRadius = Double.NaN;
            this.largeRadius = Double.NaN;
        } else {
            this.smallRadius = this.minimumMargin;
            this.largeRadius = STPShape3DTools.computeLargeRadiusFromMargins(this.minimumMargin, this.maximumMargin, STPShape3DTools.computeConvexPolytope3DMaximumEdgeLengthSquared((ConvexPolytope3DReadOnly)this.rawConvexPolytope3D));
        }
    }

    public boolean containsNaN() {
        return STPConvexPolytope3DReadOnly.super.containsNaN();
    }

    public double getVolume() {
        return this.rawConvexPolytope3D.getVolume();
    }

    public List<Face3D> getFaces() {
        return this.rawConvexPolytope3D.getFaces();
    }

    public List<HalfEdge3D> getHalfEdges() {
        return this.rawConvexPolytope3D.getHalfEdges();
    }

    public List<Vertex3D> getVertices() {
        return this.rawConvexPolytope3D.getVertices();
    }

    public double getConstructionEpsilon() {
        return this.rawConvexPolytope3D.getConstructionEpsilon();
    }

    public BoundingBox3DReadOnly getBoundingBox() {
        return this.boundingBox;
    }

    public STPConvexPolytope3D copy() {
        return new STPConvexPolytope3D(this);
    }

    public Point3DReadOnly getCentroid() {
        return this.rawConvexPolytope3D.getCentroid();
    }

    public Vertex3DReadOnly getSupportingVertex(Vector3DReadOnly supportDirection) {
        Vertex3D vertex3d = new Vertex3D(0.0, 0.0, 0.0);
        if (this.getSupportingVertex(supportDirection, (Point3DBasics)vertex3d)) {
            return vertex3d;
        }
        return null;
    }

    @Override
    public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        return this.supportingVertexCalculator.getSupportingVertex((ConvexPolytope3DReadOnly)this.rawConvexPolytope3D, this.getSmallRadius(), this.getLargeRadius(), supportDirection, supportingVertexToPack);
    }

    public Shape3DPoseBasics getPose() {
        return null;
    }

    public void applyTransform(Transform transform) {
        this.rawConvexPolytope3D.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.rawConvexPolytope3D.applyInverseTransform(transform);
    }

    public boolean equals(Object object) {
        if (object instanceof STPConvexPolytope3DReadOnly) {
            return STPConvexPolytope3DReadOnly.super.equals((STPConvexPolytope3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = EuclidHashCodeTools.combineHashCode((long)this.rawConvexPolytope3D.hashCode(), (long)EuclidHashCodeTools.toLongHashCode((double)this.minimumMargin, (double)this.maximumMargin));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        String stpSuffix = String.format("\nsmall radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + ", large radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + "]", this.getSmallRadius(), this.getLargeRadius());
        return "STP" + EuclidShapeIOTools.getConvexPolytope3DString((ConvexPolytope3DReadOnly)this) + stpSuffix;
    }

    private /* synthetic */ double lambda$new$5(Point3DReadOnly rawMaxPoint) {
        return rawMaxPoint.getZ() - this.maximumMargin;
    }

    private /* synthetic */ double lambda$new$4(Point3DReadOnly rawMaxPoint) {
        return rawMaxPoint.getY() - this.maximumMargin;
    }

    private /* synthetic */ double lambda$new$3(Point3DReadOnly rawMaxPoint) {
        return rawMaxPoint.getX() - this.maximumMargin;
    }

    private /* synthetic */ double lambda$new$2(Point3DReadOnly rawMinPoint) {
        return rawMinPoint.getZ() + this.maximumMargin;
    }

    private /* synthetic */ double lambda$new$1(Point3DReadOnly rawMinPoint) {
        return rawMinPoint.getY() + this.maximumMargin;
    }

    private /* synthetic */ double lambda$new$0(Point3DReadOnly rawMinPoint) {
        return rawMinPoint.getX() + this.maximumMargin;
    }
}

