/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.concavePolygon2D;

import java.util.List;
import us.ihmc.euclid.geometry.exceptions.EmptyPolygonException;
import us.ihmc.euclid.geometry.exceptions.OutdatedPolygonException;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.geometry.concavePolygon2D.GeometryPolygonTools;

public interface ConcavePolygon2DReadOnly
extends Vertex2DSupplier {
    public int getNumberOfVertices();

    public List<? extends Point2DReadOnly> getVertexBufferView();

    default public List<? extends Point2DReadOnly> getPolygonVerticesView() {
        return this.getVertexBufferView().subList(0, this.getNumberOfVertices());
    }

    public BoundingBox2DReadOnly getBoundingBox();

    public boolean isClockwiseOrdered();

    public double getArea();

    public Point2DReadOnly getCentroid();

    default public boolean isPointInside(Point2DReadOnly point) {
        return this.isPointInside(point.getX(), point.getY());
    }

    default public boolean isPointInside(double x, double y) {
        this.checkIfUpToDate();
        if (!this.getBoundingBox().isInsideInclusive(x, y)) {
            return false;
        }
        return GeometryPolygonTools.isPoint2DInsideSimplePolygon2D(x, y, this.getVertexBufferView(), this.getNumberOfVertices());
    }

    default public boolean isPointInsideEpsilon(Point2DReadOnly point, double epsilon) {
        return this.isPointInsideEpsilon(point.getX(), point.getY(), epsilon);
    }

    default public boolean isPointInsideEpsilon(double x, double y, double epsilon) {
        this.checkIfUpToDate();
        if (!this.getBoundingBox().isInsideEpsilon(x, y, epsilon)) {
            return false;
        }
        return GeometryPolygonTools.isPoint2DInsideSimplePolygon2D(x, y, this.getVertexBufferView(), this.getNumberOfVertices(), epsilon);
    }

    default public boolean isEmpty() {
        return this.getNumberOfVertices() == 0;
    }

    default public void checkNonEmpty() {
        if (this.isEmpty()) {
            throw new EmptyPolygonException("This polygon has no vertex.");
        }
    }

    default public void checkIndexInBoundaries(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("vertexIndex < 0");
        }
        if (index >= this.getNumberOfVertices()) {
            throw new IndexOutOfBoundsException("vertexIndex >= numberOfVertices. numberOfVertices = " + this.getNumberOfVertices());
        }
    }

    default public Point2DReadOnly getVertex(int index) {
        this.checkNonEmpty();
        this.checkIndexInBoundaries(index);
        return this.getVertexBufferView().get(index);
    }

    public boolean isUpToDate();

    default public void checkIfUpToDate() {
        if (!this.isUpToDate()) {
            throw new OutdatedPolygonException("Call the update method before doing any other calculation!");
        }
    }

    default public int getNextVertexIndex(int currentVertexIndex) {
        this.checkIfUpToDate();
        this.checkIndexInBoundaries(currentVertexIndex);
        this.checkNonEmpty();
        if (currentVertexIndex < this.getNumberOfVertices() - 1) {
            return currentVertexIndex + 1;
        }
        return 0;
    }

    default public int getPreviousVertexIndex(int currentVertexIndex) {
        this.checkIfUpToDate();
        this.checkIndexInBoundaries(currentVertexIndex);
        this.checkNonEmpty();
        if (currentVertexIndex < 1) {
            return this.getNumberOfVertices() - 1;
        }
        return currentVertexIndex - 1;
    }

    default public Point2DReadOnly getNextVertex(int index) {
        return this.getVertex(this.getNextVertexIndex(index));
    }

    default public Point2DReadOnly getPreviousVertex(int index) {
        return this.getVertex(this.getPreviousVertexIndex(index));
    }

    default public boolean epsilonEquals(ConcavePolygon2DReadOnly other, double epsilon) {
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < other.getNumberOfVertices(); ++i) {
            Point2DReadOnly thisVertex = this.getVertexBufferView().get(i);
            if (other.epsilonContains(thisVertex, epsilon)) continue;
            return false;
        }
        return true;
    }

    default public boolean epsilonContains(Point2DReadOnly thisVertex, double epsilon) {
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (!this.getVertexBufferView().get(i).epsilonEquals((EuclidGeometry)thisVertex, epsilon)) continue;
            return true;
        }
        return false;
    }
}

