/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import com.github.quickhull3d.Point3d;
import com.github.quickhull3d.QuickHull3D;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.robotics.geometry.HullFace;

public class QuickHull3dWrapper {
    QuickHull3D quickHull3D;
    List<Point3D> vertices = new ArrayList<Point3D>();
    List<HullFace> faces = new ArrayList<HullFace>();

    public QuickHull3dWrapper() {
        this.quickHull3D = new QuickHull3D();
    }

    public QuickHull3dWrapper(List<Point3D> point3dList) {
        this.quickHull3D = new QuickHull3D();
        this.build(point3dList);
    }

    public void build(List<Point3D> point3dList) {
        this.quickHull3D.build(this.getPointArrayFromPointList(point3dList));
        this.computeWrapperVerticesAndFaces();
    }

    public double getNumVertices() {
        return this.vertices.size();
    }

    public double getNumFaces() {
        return this.faces.size();
    }

    public List<Point3D> getVertices() {
        return this.vertices;
    }

    public List<HullFace> getFaces() {
        return this.faces;
    }

    private void computeWrapperVerticesAndFaces() {
        this.vertices = this.getPointListFromPointArray(this.quickHull3D.getVertices());
        this.faces.clear();
        int[][] faceArrays = this.quickHull3D.getFaces(1);
        for (int i = 0; i < faceArrays.length; ++i) {
            this.faces.add(new HullFace(this.vertices, faceArrays[i]));
        }
    }

    private Point3d[] getPointArrayFromPointList(List<Point3D> point3dList) {
        Point3d[] pointArray = new Point3d[point3dList.size()];
        int index = 0;
        for (Point3D point3d : point3dList) {
            pointArray[index] = this.createPoint3d(point3d);
            ++index;
        }
        return pointArray;
    }

    private List<Point3D> getPointListFromPointArray(Point3d[] pointArray) {
        ArrayList<Point3D> point3dList = new ArrayList<Point3D>();
        for (Point3d point3d : pointArray) {
            point3dList.add(this.createPoint3d(point3d));
        }
        return point3dList;
    }

    private Point3d createPoint3d(Point3D point3d) {
        return new Point3d(point3d.getX(), point3d.getY(), point3d.getZ());
    }

    private Point3D createPoint3d(Point3d point3d) {
        return new Point3D(point3d.x, point3d.y, point3d.z);
    }

    public double getDistanceTolerance() {
        return this.quickHull3D.getDistanceTolerance();
    }

    public void setDistanceTolerance(double tolerance) {
        this.quickHull3D.setExplicitDistanceTolerance(tolerance);
    }
}

