/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.Stack;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameBox3D;
import us.ihmc.euclid.referenceFrame.FrameRamp3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameRamp3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.PlanerRegionBuilderTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class PlanarRegionsListBuilder {
    private PlanarRegionsList planarRegionsList = new PlanarRegionsList();
    private PoseReferenceFrame placementFrame = new PoseReferenceFrame("placementFrame", ReferenceFrame.getWorldFrame());
    private Stack<Pose3D> placementFrameStack = new Stack();

    public PoseReferenceFrame getPlacementFrame() {
        return this.placementFrame;
    }

    public PlanarRegionsList getPlanarRegionsList() {
        return this.planarRegionsList;
    }

    public void setRegionIds() {
        this.setRegionIds(0);
    }

    public void setRegionIds(int startId) {
        PlanerRegionBuilderTools.setRegionsIds(startId, this.planarRegionsList);
    }

    public void addXYPlaneSquareReferencedAtCenter(double sizeX, double sizeY) {
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex(sizeX / 2.0, sizeY / 2.0);
        convexPolygon.addVertex(-sizeX / 2.0, sizeY / 2.0);
        convexPolygon.addVertex(-sizeX / 2.0, -sizeY / 2.0);
        convexPolygon.addVertex(sizeX / 2.0, -sizeY / 2.0);
        convexPolygon.update();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)this.placementFrame.getTransformToWorldFrame(), (Vertex2DSupplier)convexPolygon);
        this.planarRegionsList.addPlanarRegion(planarRegion);
    }

    public void addBoxReferencedAtCenter(double sizeX, double sizeY, double sizeZ) {
        this.addBoxReferencedAtCenter(new Box3D(sizeX, sizeY, sizeZ));
    }

    public void addBoxReferencedAtCenter(Box3D box) {
        this.planarRegionsList.addPlanarRegionsList(PlanerRegionBuilderTools.createRegionsFromBox((FrameBox3DReadOnly)new FrameBox3D((ReferenceFrame)this.placementFrame, (Box3DReadOnly)box)));
    }

    public void addRampReferencedAtCenter(Ramp3D ramp) {
        this.planarRegionsList.addPlanarRegionsList(PlanerRegionBuilderTools.createRegionsFromRamp((FrameRamp3DReadOnly)new FrameRamp3D((ReferenceFrame)this.placementFrame, (Ramp3DReadOnly)ramp)));
    }

    public void addBoxReferencedAtNegativeXYZCorner(double sizeX, double sizeY, double sizeZ) {
        this.addBoxReferencedAtNegativeXYZCorner(new Box3D(sizeX, sizeY, sizeZ));
    }

    public void addBoxReferencedAtNegativeXYZCorner(Box3D box) {
        this.placeWithOffset((Tuple3DReadOnly)new Point3D(box.getSizeX() / 2.0, box.getSizeY() / 2.0, box.getSizeZ() / 2.0), () -> this.addBoxReferencedAtCenter(box));
    }

    public void addBoxReferencedAtNegativeXYZCorner(Ramp3D ramp) {
        this.placeWithOffset((Tuple3DReadOnly)new Point3D(ramp.getSizeX() / 2.0, ramp.getSizeY() / 2.0, ramp.getSizeZ() / 2.0), () -> this.addRampReferencedAtCenter(ramp));
    }

    public void pushOffset(double yaw) {
        this.pushOffset((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)Axis3D.Z, yaw));
    }

    public void pushOffset(Orientation3DReadOnly orientationOffset) {
        this.pushOffset(null, orientationOffset);
    }

    public void pushOffset(Tuple2DReadOnly positionOffset) {
        this.pushOffset((Tuple3DReadOnly)new Point3D(positionOffset), null);
    }

    public void pushOffset(double x, double y) {
        this.pushOffset((Tuple3DReadOnly)new Point3D(x, y, 0.0), null);
    }

    public void pushOffset(double x, double y, double z, Axis3D axis, double angle) {
        this.pushOffset((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)axis, angle));
    }

    public void pushOffset(double x, double y, double z) {
        this.pushOffset((Tuple3DReadOnly)new Point3D(x, y, z), null);
    }

    public void pushOffset(Tuple3DReadOnly positionOffset) {
        this.pushOffset(positionOffset, null);
    }

    public void placeWithOffset(double yaw, Runnable runnable) {
        this.placeWithOffset((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)Axis3D.Z, yaw), runnable);
    }

    public void placeWithOffset(Orientation3DReadOnly orientationOffset, Runnable runnable) {
        this.placeWithOffset(null, orientationOffset, runnable);
    }

    public void placeWithOffset(Tuple2DReadOnly positionOffset, Runnable runnable) {
        this.placeWithOffset((Tuple3DReadOnly)new Point3D(positionOffset), runnable);
    }

    public void placeWithOffset(double x, double y, Runnable runnable) {
        this.placeWithOffset((Tuple3DReadOnly)new Point3D(x, y, 0.0), runnable);
    }

    public void placeWithOffset(double x, double y, double z, Axis3D axis, double angle, Runnable runnable) {
        this.placeWithOffset((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)axis, angle), runnable);
    }

    public void placeWithOffset(double x, double y, double z, Runnable runnable) {
        this.placeWithOffset((Tuple3DReadOnly)new Point3D(x, y, z), runnable);
    }

    public void placeWithOffset(Tuple3DReadOnly positionOffset, Runnable runnable) {
        this.placeWithOffset(positionOffset, null, runnable);
    }

    public void placeWithOffset(Tuple3DReadOnly positionOffset, Orientation3DReadOnly orientationOffset, Runnable userPlacement) {
        this.pushOffset(positionOffset, orientationOffset);
        userPlacement.run();
        this.popOffset();
    }

    public void pushOffset(Tuple3DReadOnly positionOffset, Orientation3DReadOnly orientationOffset) {
        Pose3D originalPlacementFrame = new Pose3D((Tuple3DReadOnly)this.placementFrame.getPosition(), (Orientation3DReadOnly)this.placementFrame.getOrientation());
        this.placementFrameStack.push(originalPlacementFrame);
        Pose3D offsetPose = new Pose3D((Pose3DReadOnly)originalPlacementFrame);
        if (positionOffset != null) {
            offsetPose.appendTranslation(positionOffset);
        }
        if (orientationOffset != null) {
            offsetPose.appendRotation(orientationOffset);
        }
        this.placementFrame.setPoseAndUpdate((Pose3DReadOnly)offsetPose);
    }

    public void popOffset() {
        this.placementFrame.setPoseAndUpdate((Pose3DReadOnly)this.placementFrameStack.pop());
    }

    public void popOffset(int numberOfOffsetsToPop) {
        for (int i = 0; i < numberOfOffsetsToPop; ++i) {
            this.placementFrame.setPoseAndUpdate((Pose3DReadOnly)this.placementFrameStack.pop());
        }
    }

    public void popAllRemainingOffsets() {
        while (!this.placementFrameStack.isEmpty()) {
            this.popOffset();
        }
    }
}

