/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class LinearMapping {
    private ArrayList<double[]> inputDimensions = new ArrayList();
    private ArrayList<double[]> outputDimensions = new ArrayList();

    public LinearMapping(ArrayList<double[]> inputDimensions, ArrayList<double[]> outputDimensions) {
        if (inputDimensions.size() != outputDimensions.size()) {
            throw new IllegalArgumentException("must have the same number of dimensions in the input and output spaces");
        }
        for (int i = 0; i < inputDimensions.size(); ++i) {
            double[] inputLimits = inputDimensions.get(i);
            double[] outputLimits = outputDimensions.get(i);
            if (inputLimits.length != 2 || outputLimits.length != 2) {
                throw new IllegalArgumentException("each element of the input and output dimension arrays must be 2 (a min and a max)");
            }
            double[] inputLimitsCopy = new double[2];
            double[] outputLimitsCopy = new double[2];
            System.arraycopy(inputLimits, 0, inputLimitsCopy, 0, 2);
            System.arraycopy(outputLimits, 0, outputLimitsCopy, 0, 2);
            this.inputDimensions.add(inputLimitsCopy);
            this.outputDimensions.add(outputLimitsCopy);
        }
    }

    public double[] mapFromInputSpaceToOutputSpace(double[] input) {
        double[] output = new double[input.length];
        this.mapFromInputSpaceToOutputSpacePacked(input, output);
        return output;
    }

    public void writeOut(PrintWriter printWriter) {
        printWriter.println(this.inputDimensions.size());
        for (double[] inputArray : this.inputDimensions) {
            printWriter.println(Arrays.toString(inputArray));
        }
        for (double[] inputArray : this.outputDimensions) {
            printWriter.println(Arrays.toString(inputArray));
        }
    }

    public void mapFromInputSpaceToOutputSpacePacked(double[] input, double[] output) {
        if (input.length != this.inputDimensions.size()) {
            throw new IllegalArgumentException("must provide a vector in the input space with the same dimension of the inputDimensions vector used to create the mapping");
        }
        if (output.length != this.inputDimensions.size()) {
            throw new IllegalArgumentException("must provide a vector in the output space with the same dimension of the inputDimensions vector used to create the mapping");
        }
        for (int i = 0; i < this.inputDimensions.size(); ++i) {
            double alpha = this.getAlphaFromValue(input[i], this.inputDimensions.get(i));
            output[i] = this.getValueFromAlpha(alpha, this.outputDimensions.get(i));
        }
    }

    public double[] mapFromOutputSpaceToInputSpace(double[] output) {
        double[] input = new double[output.length];
        this.mapFromOutputSpaceToInputSpacePacked(input, output);
        return input;
    }

    public void mapFromOutputSpaceToInputSpacePacked(double[] input, double[] output) {
        if (input.length != this.inputDimensions.size()) {
            throw new IllegalArgumentException("must provide a vector in the input space with the same dimension of the inputDimensions vector used to create the mapping");
        }
        if (output.length != this.inputDimensions.size()) {
            throw new IllegalArgumentException("must provide a vector in the output space with the same dimension of the inputDimensions vector used to create the mapping");
        }
        for (int i = 0; i < this.inputDimensions.size(); ++i) {
            double outputValue;
            double alpha = this.getAlphaFromValue(output[i], this.outputDimensions.get(i));
            input[i] = outputValue = this.getValueFromAlpha(alpha, this.inputDimensions.get(i));
        }
    }

    private double getAlphaFromValue(double value, double[] limits) {
        return (value - limits[0]) / (limits[1] - limits[0]);
    }

    private double getValueFromAlpha(double alpha, double[] limits) {
        return limits[0] + alpha * (limits[1] - limits[0]);
    }
}

