/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import us.ihmc.euclid.Axis3D;
import us.ihmc.robotics.controllers.pidGains.DampingUpdater;
import us.ihmc.robotics.controllers.pidGains.GainCalculator;
import us.ihmc.robotics.controllers.pidGains.GainCoupling;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.YoPID3DGains;
import us.ihmc.robotics.controllers.pidGains.implementations.PID3DConfiguration;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class DefaultYoPID3DGains
implements YoPID3DGains {
    private final boolean usingIntegrator;
    private final Map<Axis3D, YoDouble> kpMap = new EnumMap<Axis3D, YoDouble>(Axis3D.class);
    private final Map<Axis3D, YoDouble> kdMap = new EnumMap<Axis3D, YoDouble>(Axis3D.class);
    private final Map<Axis3D, YoDouble> kiMap = new EnumMap<Axis3D, YoDouble>(Axis3D.class);
    private final Map<Axis3D, YoDouble> zetaMap = new EnumMap<Axis3D, YoDouble>(Axis3D.class);
    private final YoDouble maxIntegralError;
    private final YoDouble maxDerivativeError;
    private final YoDouble maxProportionalError;
    private final YoDouble maxFeedback;
    private final YoDouble maxFeedbackRate;
    private final double[] tempProportionalGains = new double[3];
    private final double[] tempDerivativeGains = new double[3];
    private final double[] tempIntegralGains = new double[3];
    private final YoBoolean updateFromDampingRatio;

    public DefaultYoPID3DGains(String suffix, PID3DConfiguration configuration, YoRegistry registry) {
        this(suffix, configuration.getGainCoupling(), configuration.isUseIntegrator(), configuration.getGains(), registry);
    }

    public DefaultYoPID3DGains(String suffix, GainCoupling gainCoupling, boolean useIntegrator, YoRegistry registry) {
        this(suffix, gainCoupling, useIntegrator, null, registry);
    }

    public DefaultYoPID3DGains(String suffix, GainCoupling gainCoupling, boolean useIntegrator, PID3DGainsReadOnly gains, YoRegistry registry) {
        this.usingIntegrator = useIntegrator;
        DefaultYoPID3DGains.populateMap(this.kpMap, "kp", suffix, gainCoupling, registry);
        DefaultYoPID3DGains.populateMap(this.kdMap, "kd", suffix, gainCoupling, registry);
        DefaultYoPID3DGains.populateMap(this.zetaMap, "zeta", suffix, gainCoupling, registry);
        if (useIntegrator) {
            DefaultYoPID3DGains.populateMap(this.kiMap, "ki", suffix, gainCoupling, registry);
            this.maxIntegralError = new YoDouble("maxIntegralError" + suffix, registry);
        } else {
            this.maxIntegralError = null;
        }
        this.updateFromDampingRatio = new YoBoolean("UpdateFromDampingRatio" + suffix, registry);
        this.updateFromDampingRatio.set(true);
        DefaultYoPID3DGains.createDampingUpdaters(this.kpMap, this.kdMap, this.zetaMap, this.updateFromDampingRatio, gainCoupling);
        this.maxDerivativeError = new YoDouble("maxDerivativeError" + suffix, registry);
        this.maxProportionalError = new YoDouble("maxProportionalError" + suffix, registry);
        this.maxFeedback = new YoDouble("maximumFeedback" + suffix, registry);
        this.maxFeedbackRate = new YoDouble("maximumFeedbackRate" + suffix, registry);
        this.maxFeedback.set(Double.POSITIVE_INFINITY);
        this.maxFeedbackRate.set(Double.POSITIVE_INFINITY);
        this.maxDerivativeError.set(Double.POSITIVE_INFINITY);
        this.maxProportionalError.set(Double.POSITIVE_INFINITY);
        if (gains != null) {
            this.set(gains);
        }
    }

    static void populateMap(Map<Axis3D, YoDouble> mapToFill, String prefix, String suffix, GainCoupling gainCoupling, YoRegistry registry) {
        switch (gainCoupling) {
            case NONE: {
                mapToFill.put(Axis3D.X, new YoDouble(prefix + "X" + suffix, registry));
                mapToFill.put(Axis3D.Y, new YoDouble(prefix + "Y" + suffix, registry));
                mapToFill.put(Axis3D.Z, new YoDouble(prefix + "Z" + suffix, registry));
                break;
            }
            case XY: {
                mapToFill.put(Axis3D.X, new YoDouble(prefix + "XY" + suffix, registry));
                mapToFill.put(Axis3D.Y, mapToFill.get(Axis3D.X));
                mapToFill.put(Axis3D.Z, new YoDouble(prefix + "Z" + suffix, registry));
                break;
            }
            case YZ: {
                mapToFill.put(Axis3D.X, new YoDouble(prefix + "X" + suffix, registry));
                mapToFill.put(Axis3D.Y, new YoDouble(prefix + "YZ" + suffix, registry));
                mapToFill.put(Axis3D.Z, mapToFill.get(Axis3D.Y));
                break;
            }
            case XZ: {
                mapToFill.put(Axis3D.X, new YoDouble(prefix + "XZ" + suffix, registry));
                mapToFill.put(Axis3D.Y, new YoDouble(prefix + "Y" + suffix, registry));
                mapToFill.put(Axis3D.Z, mapToFill.get(Axis3D.X));
                break;
            }
            case XYZ: {
                mapToFill.put(Axis3D.X, new YoDouble(prefix + "XYZ" + suffix, registry));
                mapToFill.put(Axis3D.Y, mapToFill.get(Axis3D.X));
                mapToFill.put(Axis3D.Z, mapToFill.get(Axis3D.X));
            }
        }
    }

    private static void createDampingUpdaters(Map<Axis3D, YoDouble> kpMap, Map<Axis3D, YoDouble> kdMap, Map<Axis3D, YoDouble> zetaMap, YoBoolean update, GainCoupling gainCoupling) {
        switch (gainCoupling) {
            case NONE: {
                DefaultYoPID3DGains.addDampingUpdater(Axis3D.X, kpMap, kdMap, zetaMap, update);
                DefaultYoPID3DGains.addDampingUpdater(Axis3D.Y, kpMap, kdMap, zetaMap, update);
                DefaultYoPID3DGains.addDampingUpdater(Axis3D.Z, kpMap, kdMap, zetaMap, update);
                break;
            }
            case XY: {
                DefaultYoPID3DGains.addDampingUpdater(Axis3D.X, kpMap, kdMap, zetaMap, update);
                DefaultYoPID3DGains.addDampingUpdater(Axis3D.Z, kpMap, kdMap, zetaMap, update);
                break;
            }
            case YZ: {
                DefaultYoPID3DGains.addDampingUpdater(Axis3D.X, kpMap, kdMap, zetaMap, update);
                DefaultYoPID3DGains.addDampingUpdater(Axis3D.Y, kpMap, kdMap, zetaMap, update);
                break;
            }
            case XZ: {
                DefaultYoPID3DGains.addDampingUpdater(Axis3D.X, kpMap, kdMap, zetaMap, update);
                DefaultYoPID3DGains.addDampingUpdater(Axis3D.Y, kpMap, kdMap, zetaMap, update);
                break;
            }
            case XYZ: {
                DefaultYoPID3DGains.addDampingUpdater(Axis3D.X, kpMap, kdMap, zetaMap, update);
            }
        }
    }

    private static void addDampingUpdater(Axis3D axis, Map<Axis3D, YoDouble> kpMap, Map<Axis3D, YoDouble> kdMap, Map<Axis3D, YoDouble> zetaMap, YoBoolean update) {
        YoDouble kp = kpMap.get(axis);
        YoDouble kd = kdMap.get(axis);
        YoDouble zeta = zetaMap.get(axis);
        DampingUpdater kdUpdater = new DampingUpdater(kp, kd, zeta, update);
        kp.addListener((YoVariableChangedListener)kdUpdater);
        zeta.addListener((YoVariableChangedListener)kdUpdater);
    }

    @Override
    public double[] getProportionalGains() {
        DefaultYoPID3DGains.fillFromMap(this.kpMap, this.tempProportionalGains);
        return this.tempProportionalGains;
    }

    @Override
    public double[] getDerivativeGains() {
        DefaultYoPID3DGains.fillFromMap(this.kdMap, this.tempDerivativeGains);
        return this.tempDerivativeGains;
    }

    @Override
    public double[] getIntegralGains() {
        if (!this.usingIntegrator) {
            for (int i = 0; i < 3; ++i) {
                this.tempIntegralGains[i] = 0.0;
            }
            return this.tempIntegralGains;
        }
        DefaultYoPID3DGains.fillFromMap(this.kiMap, this.tempIntegralGains);
        return this.tempIntegralGains;
    }

    static void fillFromMap(Map<Axis3D, YoDouble> map, double[] arrayToFill) {
        arrayToFill[0] = map.get(Axis3D.X).getDoubleValue();
        arrayToFill[1] = map.get(Axis3D.Y).getDoubleValue();
        arrayToFill[2] = map.get(Axis3D.Z).getDoubleValue();
    }

    @Override
    public double getMaximumIntegralError() {
        if (!this.usingIntegrator) {
            return 0.0;
        }
        return this.maxIntegralError.getDoubleValue();
    }

    @Override
    public double getMaximumDerivativeError() {
        return this.maxDerivativeError.getDoubleValue();
    }

    @Override
    public double getMaximumProportionalError() {
        return this.maxProportionalError.getDoubleValue();
    }

    @Override
    public double getMaximumFeedback() {
        return this.maxFeedback.getDoubleValue();
    }

    @Override
    public double getMaximumFeedbackRate() {
        return this.maxFeedbackRate.getDoubleValue();
    }

    @Override
    public void setProportionalGains(double proportionalGainX, double proportionalGainY, double proportionalGainZ) {
        this.kpMap.get(Axis3D.X).set(proportionalGainX);
        this.kpMap.get(Axis3D.Y).set(proportionalGainY);
        this.kpMap.get(Axis3D.Z).set(proportionalGainZ);
    }

    @Override
    public void setDerivativeGains(double derivativeGainX, double derivativeGainY, double derivativeGainZ) {
        this.updateFromDampingRatio.set(false);
        this.kdMap.get(Axis3D.X).set(derivativeGainX);
        this.kdMap.get(Axis3D.Y).set(derivativeGainY);
        this.kdMap.get(Axis3D.Z).set(derivativeGainZ);
        this.updateDampingRatios();
    }

    public void setDampingRatios(double dampingRatioX, double dampingRatioY, double dampingRatioZ) {
        this.updateFromDampingRatio.set(true);
        this.zetaMap.get(Axis3D.X).set(dampingRatioX);
        this.zetaMap.get(Axis3D.Y).set(dampingRatioY);
        this.zetaMap.get(Axis3D.Z).set(dampingRatioZ);
    }

    public void setDampingRatios(double dampingRatio) {
        this.setDampingRatios(dampingRatio, dampingRatio, dampingRatio);
    }

    private void updateDampingRatios() {
        for (int i = 0; i < Axis3D.values.length; ++i) {
            YoDouble kp = this.kpMap.get(Axis3D.values[i]);
            YoDouble kd = this.kdMap.get(Axis3D.values[i]);
            YoDouble zeta = this.zetaMap.get(Axis3D.values[i]);
            zeta.set(GainCalculator.computeDampingRatio(kp.getDoubleValue(), kd.getDoubleValue()));
        }
    }

    @Override
    public void setIntegralGains(double integralGainX, double integralGainY, double integralGainZ, double maxIntegralError) {
        if (!this.usingIntegrator) {
            return;
        }
        this.kiMap.get(Axis3D.X).set(integralGainX);
        this.kiMap.get(Axis3D.Y).set(integralGainY);
        this.kiMap.get(Axis3D.Z).set(integralGainZ);
        this.maxIntegralError.set(maxIntegralError);
    }

    @Override
    public void setMaxFeedbackAndFeedbackRate(double maxFeedback, double maxFeedbackRate) {
        this.maxFeedback.set(maxFeedback);
        this.maxFeedbackRate.set(maxFeedbackRate);
    }

    @Override
    public void setMaxDerivativeError(double maxDerivativeError) {
        this.maxDerivativeError.set(maxDerivativeError);
    }

    @Override
    public void setMaxProportionalError(double maxProportionalError) {
        this.maxProportionalError.set(maxProportionalError);
    }

    @Override
    public YoDouble getYoMaximumFeedback() {
        return this.maxFeedback;
    }

    @Override
    public YoDouble getYoMaximumFeedbackRate() {
        return this.maxFeedbackRate;
    }

    @Override
    public YoDouble getYoMaximumDerivativeError() {
        return this.maxDerivativeError;
    }

    @Override
    public YoDouble getYoMaximumProportionalError() {
        return this.maxProportionalError;
    }

    public boolean equals(Object object) {
        if (object instanceof PID3DGainsReadOnly) {
            return YoPID3DGains.super.equals((PID3DGainsReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": kp: " + Arrays.toString(this.getProportionalGains()) + ", kd: " + Arrays.toString(this.getDerivativeGains()) + ", ki: " + Arrays.toString(this.getIntegralGains());
    }
}

