/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import java.util.List;
import java.util.function.Consumer;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.robot.CrossFourBarJointDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class SCS2DefinitionMissingTools {
    public static void forEachRigidBodyDefinitionIncludingFourBars(RigidBodyDefinition start, Consumer<RigidBodyDefinition> rigidBodyConsumer) {
        RobotDefinition.forEachRigidBodyDefinition((RigidBodyDefinition)start, body -> {
            rigidBodyConsumer.accept((RigidBodyDefinition)body);
            for (JointDefinition childrenJoint : body.getChildrenJoints()) {
                if (!(childrenJoint instanceof CrossFourBarJointDefinition)) continue;
                CrossFourBarJointDefinition fourBarJointDefinition = (CrossFourBarJointDefinition)childrenJoint;
                rigidBodyConsumer.accept(fourBarJointDefinition.getBodyBC());
                rigidBodyConsumer.accept(fourBarJointDefinition.getBodyDA());
            }
        });
    }

    public static void addCollisionVisualsToRobot(RobotDefinition robotDefinition, MaterialDefinition material) {
        robotDefinition.forEachRigidBodyDefinition(rigidBody -> SCS2DefinitionMissingTools.addCollisionVisualsToRigidBodyDefinition(rigidBody, material));
    }

    public static void addCollisionVisualsToRigidBodyDefinition(RigidBodyDefinition rigidBodyDefinition, MaterialDefinition material) {
        if (rigidBodyDefinition == null) {
            return;
        }
        List collisionShapeDefinitions = rigidBodyDefinition.getCollisionShapeDefinitions();
        if (collisionShapeDefinitions == null) {
            return;
        }
        for (CollisionShapeDefinition collisionShapeDefinition : collisionShapeDefinitions) {
            rigidBodyDefinition.addVisualDefinition(new VisualDefinition((RigidBodyTransformReadOnly)collisionShapeDefinition.getOriginPose(), collisionShapeDefinition.getGeometryDefinition(), material));
        }
    }
}

