/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.statistics;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotics.functionApproximation.ProbabilityDensityFunction;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLine2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class Line2DStatisticsCalculator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoDouble heading;
    private final YoFrameLine2D meanLine;
    private final Vector2D direction = new Vector2D();
    private final Line2DReadOnly lineVariable;
    private final YoDouble positionVariance;
    private final YoDouble positionPopulationVariance;
    private final YoDouble positionStandardDeviation;
    private final YoDouble positionErrorSumOfSquare;
    private final YoDouble directionVariance;
    private final YoDouble directionPopulationVariance;
    private final YoDouble directionStandardDeviation;
    private final YoDouble headingMean;
    private final YoDouble directionErrorSumOfSquare;
    private final YoInteger numberOfSamples;
    private final Point2D previousPositionMean = new Point2D();

    public Line2DStatisticsCalculator(String prefix, Line2DReadOnly lineVariable, YoRegistry registry) {
        this.lineVariable = lineVariable;
        this.heading = new YoDouble(prefix + "_Heading", registry);
        this.positionVariance = new YoDouble(prefix + "_PositionVariance", registry);
        this.positionPopulationVariance = new YoDouble(prefix + "_PositionPopulationVariance", registry);
        this.positionStandardDeviation = new YoDouble(prefix + "_PositionStandardDeviation", registry);
        this.positionErrorSumOfSquare = new YoDouble(prefix + "_PositionErrorSumOfSquare", registry);
        this.directionVariance = new YoDouble(prefix + "_DirectionVariance", registry);
        this.directionPopulationVariance = new YoDouble(prefix + "_DirectionPopulationVariance", registry);
        this.directionStandardDeviation = new YoDouble(prefix + "_DirectionStandardDeviation", registry);
        this.headingMean = new YoDouble(prefix + "_HeadingMean", registry);
        this.meanLine = new YoFrameLine2D(prefix + "_MeanLine", worldFrame, registry);
        this.directionErrorSumOfSquare = new YoDouble(prefix + "_DirectionErrorSumOfSquare", registry);
        this.numberOfSamples = new YoInteger(prefix + "_NumberOfLineSamples", registry);
    }

    public void reset() {
        this.positionVariance.set(0.0);
        this.positionPopulationVariance.set(0.0);
        this.positionStandardDeviation.set(0.0);
        this.positionErrorSumOfSquare.set(0.0);
        this.directionVariance.set(0.0);
        this.directionPopulationVariance.set(0.0);
        this.directionStandardDeviation.set(0.0);
        this.headingMean.set(0.0);
        this.directionErrorSumOfSquare.set(0.0);
        this.numberOfSamples.set(0);
    }

    public void update() {
        Point2DReadOnly incomingPosition = this.lineVariable.getPoint();
        this.heading.set(Line2DStatisticsCalculator.calculateHeading((Vector2DReadOnly)this.lineVariable.getDirection()));
        this.direction.set(Math.cos(this.heading.getDoubleValue()), Math.sin(this.heading.getDoubleValue()));
        double totalHeadingValue = (double)this.numberOfSamples.getIntegerValue() * this.headingMean.getDoubleValue() + this.heading.getDoubleValue();
        double previousHeadingMean = this.headingMean.getDoubleValue();
        this.numberOfSamples.increment();
        this.headingMean.set(totalHeadingValue / (double)this.numberOfSamples.getIntegerValue());
        this.meanLine.getDirection().set(Math.cos(this.headingMean.getDoubleValue()), Math.sin(this.headingMean.getDoubleValue()));
        this.meanLine.orthogonalProjection(incomingPosition, (Point2DBasics)this.previousPositionMean);
        this.meanLine.getPoint().interpolate((Tuple2DReadOnly)this.previousPositionMean, (Tuple2DReadOnly)incomingPosition, 1.0 / (double)this.numberOfSamples.getIntegerValue());
        if (this.numberOfSamples.getIntegerValue() > 1) {
            double difference = AngleTools.computeAngleDifferenceMinusPiToPi(this.heading.getDoubleValue(), this.headingMean.getDoubleValue());
            double previousDifference = AngleTools.computeAngleDifferenceMinusPiToPi(this.heading.getDoubleValue(), previousHeadingMean);
            this.directionErrorSumOfSquare.add(difference * previousDifference);
            this.directionPopulationVariance.set(this.directionErrorSumOfSquare.getDoubleValue() / (double)(this.numberOfSamples.getIntegerValue() - 1));
            this.directionVariance.set(this.directionErrorSumOfSquare.getDoubleValue() / (double)this.numberOfSamples.getIntegerValue());
            this.positionErrorSumOfSquare.add(incomingPosition.distance((Point2DReadOnly)this.previousPositionMean) * incomingPosition.distance((Point2DReadOnly)this.meanLine.getPoint()));
            this.positionPopulationVariance.set(this.positionErrorSumOfSquare.getDoubleValue() / (double)(this.numberOfSamples.getIntegerValue() - 1));
            this.positionVariance.set(this.positionErrorSumOfSquare.getDoubleValue() / (double)this.numberOfSamples.getIntegerValue());
        }
        if (MathTools.epsilonEquals((double)this.positionVariance.getDoubleValue(), (double)0.0, (double)1.0E-10)) {
            this.positionStandardDeviation.set(0.0);
        } else {
            this.positionStandardDeviation.set(Math.sqrt(this.positionVariance.getDoubleValue()));
        }
        if (MathTools.epsilonEquals((double)this.directionVariance.getDoubleValue(), (double)0.0, (double)1.0E-10)) {
            this.directionStandardDeviation.set(0.0);
        } else {
            this.directionStandardDeviation.set(Math.sqrt(this.directionVariance.getDoubleValue()));
        }
    }

    public double getPositionStandardDeviation() {
        return this.positionStandardDeviation.getDoubleValue();
    }

    public double getPositionVariance() {
        return this.positionVariance.getValue();
    }

    public double getDirectionStandardDeviation() {
        return this.directionStandardDeviation.getDoubleValue();
    }

    public double getDirectionVariance() {
        return this.directionVariance.getDoubleValue();
    }

    public Line2DReadOnly getLineMean() {
        return this.meanLine;
    }

    static double calculateHeading(Vector2DReadOnly direction) {
        return Line2DStatisticsCalculator.calculateHeading(direction.getX(), direction.getY());
    }

    private static double calculateHeading(double deltaX, double deltaY) {
        double angle = Math.atan2(deltaY, deltaX);
        if (angle < 0.0) {
            angle += Math.PI;
        }
        return angle;
    }

    public double getProbabilityPointIsOnLine(Point2DReadOnly point) {
        double distanceToMean = this.getLineMean().distance(point);
        return ProbabilityDensityFunction.getProbabilityUsingNormalDistribution(distanceToMean, 0.0, this.getPositionStandardDeviation());
    }
}

