/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sensors;

import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;

public class ForceSensorDefinition
implements Settable<ForceSensorDefinition> {
    private String sensorName;
    private RigidBodyBasics rigidBody;
    private ReferenceFrame sensorFrame;

    public static ReferenceFrame createSensorFrame(String sensorName, RigidBodyBasics rigidBody, RigidBodyTransformReadOnly transformFromSensorToParentJoint) {
        MovingReferenceFrame frameAfterJoint = rigidBody.getParentJoint().getFrameAfterJoint();
        return ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)(sensorName + "Frame"), (ReferenceFrame)frameAfterJoint, (RigidBodyTransformReadOnly)transformFromSensorToParentJoint);
    }

    public ForceSensorDefinition() {
    }

    public ForceSensorDefinition(String sensorName, RigidBodyBasics rigidBody, ReferenceFrame sensorFrame) {
        this.set(sensorName, rigidBody, sensorFrame);
    }

    public void set(ForceSensorDefinition other) {
        this.set(other.sensorName, other.rigidBody, other.sensorFrame);
    }

    public void set(String sensorName, RigidBodyBasics rigidBody, ReferenceFrame sensorFrame) {
        this.sensorName = sensorName;
        this.rigidBody = rigidBody;
        this.sensorFrame = sensorFrame;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public ReferenceFrame getSensorFrame() {
        return this.sensorFrame;
    }

    public String toString() {
        return "ForceSensorDefinition: " + this.sensorName + " attached to " + this.rigidBody.getName();
    }

    public int hashCode() {
        return this.sensorName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ForceSensorDefinition) {
            ForceSensorDefinition other = (ForceSensorDefinition)obj;
            if (!this.getSensorName().equals(other.getSensorName())) {
                return false;
            }
            if (this.rigidBody != other.rigidBody) {
                return false;
            }
            return this.sensorFrame == other.sensorFrame;
        }
        return false;
    }
}

