/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sensors;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.screwTheory.GenericCRC32;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDefinition;

public class ForceSensorData
implements ForceSensorDataReadOnly,
Settable<ForceSensorData> {
    private final DMatrixRMaj wrench = new DMatrixRMaj(6, 1);
    private String sensorName;
    private ReferenceFrame measurementFrame;
    private RigidBodyBasics measurementLink;

    public ForceSensorData() {
    }

    public ForceSensorData(ForceSensorDefinition forceSensorDefinition) {
        this.setDefinition(forceSensorDefinition);
    }

    public void setDefinition(ForceSensorDefinition forceSensorDefinition) {
        this.setDefinition(forceSensorDefinition.getSensorName(), forceSensorDefinition.getSensorFrame(), forceSensorDefinition.getRigidBody());
    }

    public void setDefinition(String sensorName, ReferenceFrame measurementFrame, RigidBodyBasics measurementLink) {
        this.sensorName = sensorName;
        this.measurementFrame = measurementFrame;
        this.measurementLink = measurementLink;
    }

    public void setWrench(Vector3DReadOnly moment, Vector3DReadOnly force) {
        moment.get(0, (DMatrix)this.wrench);
        force.get(3, (DMatrix)this.wrench);
    }

    public void setWrench(DMatrixRMaj newWrench) {
        this.wrench.set((DMatrixD1)newWrench);
    }

    public void setWrench(float[] newWrench) {
        for (int i = 0; i < 6; ++i) {
            this.wrench.set(i, 0, (double)newWrench[i]);
        }
    }

    public void setWrench(WrenchReadOnly newWrench) {
        this.measurementFrame.checkReferenceFrameMatch(newWrench.getReferenceFrame());
        this.measurementFrame.checkReferenceFrameMatch(newWrench.getBodyFrame());
        newWrench.get((DMatrix)this.wrench);
    }

    @Override
    public String getSensorName() {
        return this.sensorName;
    }

    @Override
    public ReferenceFrame getMeasurementFrame() {
        return this.measurementFrame;
    }

    @Override
    public RigidBodyBasics getMeasurementLink() {
        return this.measurementLink;
    }

    @Override
    public void getWrench(DMatrixRMaj wrenchToPack) {
        wrenchToPack.set((DMatrixD1)this.wrench);
    }

    @Override
    public void getWrench(Wrench wrenchToPack) {
        wrenchToPack.setBodyFrame(this.measurementFrame);
        wrenchToPack.setIncludingFrame(this.measurementFrame, (DMatrix)this.wrench);
    }

    @Override
    public void getWrench(Vector3DBasics momentToPack, Vector3DBasics forceToPack) {
        momentToPack.set(0, (DMatrix)this.wrench);
        forceToPack.set(3, (DMatrix)this.wrench);
    }

    @Override
    public void getWrench(float[] wrenchToPack) {
        for (int i = 0; i < 6; ++i) {
            wrenchToPack[i] = (float)this.wrench.get(i, 0);
        }
    }

    public void set(ForceSensorData other) {
        this.set((ForceSensorDataReadOnly)other);
    }

    public void set(ForceSensorDataReadOnly other) {
        this.sensorName = other.getSensorName();
        this.measurementFrame = other.getMeasurementFrame();
        this.measurementLink = other.getMeasurementLink();
        other.getWrench(this.wrench);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ForceSensorData) {
            ForceSensorData other = (ForceSensorData)obj;
            if (this.sensorName == null ? other.sensorName != null : !this.sensorName.equals(other.sensorName)) {
                return false;
            }
            if (this.measurementFrame != other.measurementFrame) {
                return false;
            }
            if (this.measurementLink != other.measurementLink) {
                return false;
            }
            return MatrixTools.equals((DMatrix1Row)this.wrench, (DMatrix1Row)other.wrench);
        }
        return false;
    }

    public void calculateChecksum(GenericCRC32 checksum) {
        checksum.update(this.wrench);
    }
}

