/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class TwistCalculator {
    private final ReferenceFrame inertialFrame;
    private final RigidBodyBasics rootBody;
    private final Twist rootTwist;
    private final HashMap<RigidBodyBasics, MutableInt> rigidBodyToAssignedTwistIndex = new HashMap();
    private final List<RigidBodyBasics> rigidBodiesWithAssignedTwist;
    private final List<Twist> assignedTwists;
    private final List<Twist> unnassignedTwists = new ArrayList<Twist>();
    private final Twist twistForGetRelativeTwist = new Twist();
    private final Twist twistForGetAngularVelocityOfBody = new Twist();
    private final Twist twistForGetLinearVelocityOfBodyFixedPoint = new Twist();
    private final FramePoint3D pointForGetLinearVelocityOfBodyFixedPoint = new FramePoint3D();
    private final Twist twistForComputeOrGetTwistOfBody = new Twist();

    public TwistCalculator(ReferenceFrame inertialFrame, RigidBodyBasics body) {
        this.inertialFrame = inertialFrame;
        this.rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)body);
        this.rootTwist = new Twist((ReferenceFrame)this.rootBody.getBodyFixedFrame(), inertialFrame, (ReferenceFrame)this.rootBody.getBodyFixedFrame());
        int numberOfRigidBodies = MultiBodySystemTools.collectSubtreeSuccessors((JointBasics[])MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{this.rootBody})).length;
        while (this.unnassignedTwists.size() < numberOfRigidBodies) {
            this.unnassignedTwists.add(new Twist());
        }
        this.assignedTwists = new ArrayList<Twist>(numberOfRigidBodies);
        this.rigidBodiesWithAssignedTwist = new ArrayList<RigidBodyBasics>(numberOfRigidBodies);
        this.assignedTwists.add(this.rootTwist);
        this.rigidBodiesWithAssignedTwist.add(this.rootBody);
        this.rigidBodyToAssignedTwistIndex.put(this.rootBody, new MutableInt(0));
    }

    public void compute() {
        while (this.rigidBodiesWithAssignedTwist.size() > 1) {
            this.rigidBodyToAssignedTwistIndex.get(this.rigidBodiesWithAssignedTwist.remove(this.rigidBodiesWithAssignedTwist.size() - 1)).setValue(-1);
        }
        while (this.assignedTwists.size() > 1) {
            this.unnassignedTwists.add(this.assignedTwists.remove(this.assignedTwists.size() - 1));
        }
        this.rigidBodyToAssignedTwistIndex.get(this.rootBody).setValue(0);
    }

    public void getTwistOfBody(RigidBodyBasics body, Twist twistToPack) {
        twistToPack.setIncludingFrame((SpatialMotionReadOnly)this.computeOrGetTwistOfBody(body));
    }

    public void getRelativeTwist(RigidBodyBasics base, RigidBodyBasics body, Twist twistToPack) {
        twistToPack.setIncludingFrame((SpatialMotionReadOnly)this.computeOrGetTwistOfBody(body));
        this.twistForGetRelativeTwist.setIncludingFrame((SpatialMotionReadOnly)this.computeOrGetTwistOfBody(base));
        this.twistForGetRelativeTwist.changeFrame(twistToPack.getReferenceFrame());
        twistToPack.sub((TwistReadOnly)this.twistForGetRelativeTwist);
    }

    public void getAngularVelocityOfBody(RigidBodyBasics body, FrameVector3D angularVelocityToPack) {
        this.getTwistOfBody(body, this.twistForGetAngularVelocityOfBody);
        angularVelocityToPack.setIncludingFrame((FrameTuple3DReadOnly)this.twistForGetAngularVelocityOfBody.getAngularPart());
    }

    public void getRelativeAngularVelocity(RigidBodyBasics base, RigidBodyBasics body, FrameVector3D angularVelocityToPack) {
        this.getRelativeTwist(base, body, this.twistForGetAngularVelocityOfBody);
        angularVelocityToPack.setIncludingFrame((FrameTuple3DReadOnly)this.twistForGetAngularVelocityOfBody.getAngularPart());
    }

    public void getLinearVelocityOfBodyFixedPoint(RigidBodyBasics body, FramePoint3D bodyFixedPoint, FrameVector3D linearVelocityToPack) {
        FramePoint3D localPoint = this.pointForGetLinearVelocityOfBodyFixedPoint;
        Twist localTwist = this.twistForGetLinearVelocityOfBodyFixedPoint;
        this.getTwistOfBody(body, localTwist);
        ReferenceFrame baseFrame = localTwist.getBaseFrame();
        localPoint.setIncludingFrame((FrameTuple3DReadOnly)bodyFixedPoint);
        localTwist.changeFrame(baseFrame);
        localPoint.changeFrame(baseFrame);
        localTwist.getLinearVelocityAt((FramePoint3DReadOnly)localPoint, (FrameVector3DBasics)linearVelocityToPack);
    }

    public void getLinearVelocityOfBodyFixedPoint(RigidBodyBasics base, RigidBodyBasics body, FramePoint3D bodyFixedPoint, FrameVector3D linearVelocityToPack) {
        FramePoint3D localPoint = this.pointForGetLinearVelocityOfBodyFixedPoint;
        Twist localTwist = this.twistForGetLinearVelocityOfBodyFixedPoint;
        this.getRelativeTwist(base, body, localTwist);
        ReferenceFrame baseFrame = localTwist.getBaseFrame();
        localPoint.setIncludingFrame((FrameTuple3DReadOnly)bodyFixedPoint);
        localTwist.changeFrame(baseFrame);
        localPoint.changeFrame(baseFrame);
        localTwist.getLinearVelocityAt((FramePoint3DReadOnly)localPoint, (FrameVector3DBasics)linearVelocityToPack);
    }

    public RigidBodyBasics getRootBody() {
        return this.rootBody;
    }

    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }

    private TwistReadOnly computeOrGetTwistOfBody(RigidBodyBasics body) {
        Twist twist = this.retrieveAssignedTwist(body);
        if (twist == null) {
            MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
            JointBasics parentJoint = body.getParentJoint();
            RigidBodyBasics predecessor = parentJoint.getPredecessor();
            TwistReadOnly twistOfPredecessor = this.computeOrGetTwistOfBody(predecessor);
            twist = this.assignAndGetEmptyTwist(body);
            parentJoint.getSuccessorTwist((TwistBasics)this.twistForComputeOrGetTwistOfBody);
            twist.setIncludingFrame((SpatialMotionReadOnly)twistOfPredecessor);
            twist.changeFrame((ReferenceFrame)bodyFrame);
            twist.add((TwistReadOnly)this.twistForComputeOrGetTwistOfBody);
        }
        return twist;
    }

    private Twist retrieveAssignedTwist(RigidBodyBasics body) {
        int assignedTwistIndex;
        MutableInt mutableIndex = this.rigidBodyToAssignedTwistIndex.get(body);
        if (mutableIndex == null) {
            mutableIndex = new MutableInt(-1);
            this.rigidBodyToAssignedTwistIndex.put(body, mutableIndex);
        }
        if ((assignedTwistIndex = mutableIndex.intValue()) == -1) {
            return null;
        }
        return this.assignedTwists.get(assignedTwistIndex);
    }

    private Twist assignAndGetEmptyTwist(RigidBodyBasics body) {
        Twist newAssignedTwist = this.unnassignedTwists.isEmpty() ? new Twist() : this.unnassignedTwists.remove(this.unnassignedTwists.size() - 1);
        MutableInt mutableIndex = this.rigidBodyToAssignedTwistIndex.get(body);
        if (mutableIndex == null) {
            mutableIndex = new MutableInt();
            this.rigidBodyToAssignedTwistIndex.put(body, mutableIndex);
        }
        mutableIndex.setValue(this.assignedTwists.size());
        this.rigidBodiesWithAssignedTwist.add(body);
        this.assignedTwists.add(newAssignedTwist);
        return newAssignedTwist;
    }
}

