/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.screwTheory.GeometricJacobian;

public class PointJacobian {
    private GeometricJacobian geometricJacobian;
    private final FramePoint3D point = new FramePoint3D(ReferenceFrame.getWorldFrame());
    private final DMatrixRMaj jacobianMatrix = new DMatrixRMaj(1, 1);
    private final Vector3D tempJacobianColumn = new Vector3D();
    private final Vector3D translation = new Vector3D();
    private final Vector3D tempVector = new Vector3D();

    public void set(GeometricJacobian geometricJacobian, FramePoint3D point) {
        if (geometricJacobian.getBaseFrame() != geometricJacobian.getJacobianFrame()) {
            throw new RuntimeException("Jacobian must be expressed in base frame");
        }
        this.geometricJacobian = geometricJacobian;
        this.point.setIncludingFrame((FrameTuple3DReadOnly)point);
        this.point.changeFrame(geometricJacobian.getBaseFrame());
        this.jacobianMatrix.reshape(3, geometricJacobian.getNumberOfColumns());
    }

    public void compute() {
        this.translation.set((Tuple3DReadOnly)this.point);
        int angularPartStartRow = 0;
        int linearPartStartRow = 3;
        for (int i = 0; i < this.geometricJacobian.getNumberOfColumns(); ++i) {
            DMatrixRMaj geometricJacobianMatrix = this.geometricJacobian.getJacobianMatrix();
            this.tempVector.set(angularPartStartRow, i, (DMatrix)geometricJacobianMatrix);
            this.tempJacobianColumn.cross((Tuple3DReadOnly)this.tempVector, (Tuple3DReadOnly)this.translation);
            this.tempVector.set(linearPartStartRow, i, (DMatrix)geometricJacobianMatrix);
            this.tempJacobianColumn.add((Tuple3DReadOnly)this.tempVector);
            this.tempJacobianColumn.get(angularPartStartRow, i, (DMatrix)this.jacobianMatrix);
        }
    }

    public ReferenceFrame getFrame() {
        return this.geometricJacobian.getBaseFrame();
    }

    public DMatrixRMaj getJacobianMatrix() {
        return this.jacobianMatrix;
    }

    public GeometricJacobian getGeometricJacobian() {
        return this.geometricJacobian;
    }

    public FramePoint3D getPoint() {
        return this.point;
    }
}

