/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;

public class MovingZUpFrame
extends MovingReferenceFrame {
    private final ReferenceFrame rootFrame;
    private final MovingReferenceFrame nonZUpFrame;
    private double sinRoll = 0.0;
    private double cosRoll = 1.0;
    private double cosPitch = 1.0;

    public MovingZUpFrame(MovingReferenceFrame nonZUpFrame, String name) {
        super(name, nonZUpFrame.getRootFrame(), true);
        this.rootFrame = nonZUpFrame.getRootFrame();
        this.nonZUpFrame = nonZUpFrame;
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.nonZUpFrame.getTransformToDesiredFrame(transformToParent, this.rootFrame);
        double sinPitch = -transformToParent.getM20();
        this.cosPitch = Math.sqrt(1.0 - sinPitch * sinPitch);
        if (EuclidCoreTools.isZero((double)this.cosPitch, (double)1.0E-12)) {
            this.cosRoll = 1.0;
            this.sinRoll = 0.0;
            transformToParent.getRotation().setIdentity();
        } else {
            this.cosRoll = transformToParent.getM22() / this.cosPitch;
            this.sinRoll = transformToParent.getM21() / this.cosPitch;
            double invNormRoll = 1.0 / EuclidCoreTools.norm((double)this.cosRoll, (double)this.sinRoll);
            this.cosRoll *= invNormRoll;
            this.sinRoll *= invNormRoll;
            double cosYaw = transformToParent.getM00() / this.cosPitch;
            double sinYaw = transformToParent.getM10() / this.cosPitch;
            double invNormYaw = 1.0 / EuclidCoreTools.norm((double)cosYaw, (double)sinYaw);
            transformToParent.getRotation().setUnsafe(cosYaw *= invNormYaw, -(sinYaw *= invNormYaw), 0.0, sinYaw, cosYaw, 0.0, 0.0, 0.0, 1.0);
        }
    }

    protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
        double yawDot;
        this.nonZUpFrame.getTwistOfFrame((TwistBasics)twistRelativeToParentToPack);
        if (EuclidCoreTools.isZero((double)this.cosPitch, (double)1.0E-12)) {
            yawDot = 0.0;
        } else {
            double wy = twistRelativeToParentToPack.getAngularPartY();
            double wz = twistRelativeToParentToPack.getAngularPartZ();
            yawDot = (this.sinRoll * wy + this.cosRoll * wz) / this.cosPitch;
        }
        twistRelativeToParentToPack.changeFrame((ReferenceFrame)this);
        twistRelativeToParentToPack.setBodyFrame((ReferenceFrame)this);
        twistRelativeToParentToPack.setBaseFrame(this.rootFrame);
        twistRelativeToParentToPack.getAngularPart().set(0.0, 0.0, yawDot);
    }
}

