/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.stream.Stream;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.FixedFrameMomentumBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public class MomentumCalculator {
    private final RigidBodyReadOnly[] rigidBodiesInOrders;
    private final Twist bodyTwist = new Twist();
    private final Momentum bodyMomentum = new Momentum();
    private ReferenceFrame baseFrame = null;

    public MomentumCalculator(RigidBodyReadOnly ... rigidBodies) {
        this.rigidBodiesInOrders = (RigidBodyReadOnly[])Stream.of(rigidBodies).filter(body -> body.getInertia() != null).toArray(RigidBodyReadOnly[]::new);
    }

    public MomentumCalculator(RigidBodyReadOnly rootBody) {
        this(rootBody.subtreeArray());
    }

    public MomentumCalculator(MultiBodySystemReadOnly input) {
        this.rigidBodiesInOrders = (RigidBodyReadOnly[])input.getJointsToConsider().stream().map(JointReadOnly::getSuccessor).filter(body -> body.getInertia() != null).toArray(RigidBodyReadOnly[]::new);
    }

    public void setBaseFrame(ReferenceFrame baseFrame) {
        this.baseFrame = baseFrame;
    }

    public void computeAndPack(FixedFrameMomentumBasics momentum) {
        momentum.setToZero();
        if (this.baseFrame == null) {
            for (RigidBodyReadOnly rigidBody : this.rigidBodiesInOrders) {
                SpatialInertiaReadOnly inertia = rigidBody.getInertia();
                this.bodyMomentum.setReferenceFrame(inertia.getReferenceFrame());
                this.bodyMomentum.compute(inertia, rigidBody.getBodyFixedFrame().getTwistOfFrame());
                this.bodyMomentum.changeFrame(momentum.getReferenceFrame());
                momentum.add((SpatialVectorReadOnly)this.bodyMomentum);
            }
        } else {
            for (RigidBodyReadOnly rigidBody : this.rigidBodiesInOrders) {
                SpatialInertiaReadOnly inertia = rigidBody.getInertia();
                this.bodyMomentum.setReferenceFrame(inertia.getReferenceFrame());
                rigidBody.getBodyFixedFrame().getTwistRelativeToOther(this.baseFrame, (TwistBasics)this.bodyTwist);
                this.bodyMomentum.compute(inertia, (TwistReadOnly)this.bodyTwist);
                this.bodyMomentum.changeFrame(momentum.getReferenceFrame());
                momentum.add((SpatialVectorReadOnly)this.bodyMomentum);
            }
        }
    }
}

