/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotSide;

import java.util.Random;

public enum RobotEnd {
    HIND,
    FRONT;

    public static final RobotEnd[] values;

    public static RobotEnd generateRandomRobotEnd(Random random) {
        if (random.nextBoolean()) {
            return FRONT;
        }
        return HIND;
    }

    public RobotEnd getOppositeEnd() {
        if (this == HIND) {
            return FRONT;
        }
        return HIND;
    }

    public String getShortLowerCaseName() {
        return this.getCamelCaseNameForMiddleOfExpression().substring(0, 1).toLowerCase();
    }

    public String getCamelCaseNameForStartOfExpression() {
        if (this == HIND) {
            return "hind";
        }
        return "front";
    }

    public String getCamelCaseNameForMiddleOfExpression() {
        if (this == HIND) {
            return "Hind";
        }
        return "Front";
    }

    public String getLowerCaseName() {
        if (this == HIND) {
            return "hind";
        }
        return "front";
    }

    public String getSideNameInAllCaps() {
        if (this == HIND) {
            return "HIND";
        }
        return "FRONT";
    }

    public String getEndNameFirstLetter() {
        if (this == HIND) {
            return "H";
        }
        return "F";
    }

    public double negateIfFrontEnd(double value) {
        if (this == FRONT) {
            return -value;
        }
        return value;
    }

    public double negateIfHindEnd(double value) {
        if (this == HIND) {
            return -value;
        }
        return value;
    }

    public float negateIfFrontEnd(float value) {
        if (this == FRONT) {
            return -value;
        }
        return value;
    }

    public float negateIfHindEnd(float value) {
        if (this == HIND) {
            return -value;
        }
        return value;
    }

    public void checkRobotEndMatch(RobotEnd other) {
        if (this != other) {
            throw new RobotEndMismatchException();
        }
    }

    public static RobotEnd getEndFromString(String robotEndName) {
        RobotEnd[] ends;
        for (RobotEnd end : ends = values) {
            if (!robotEndName.equals(end.getEndNameFirstLetter())) continue;
            return end;
        }
        return null;
    }

    public String getDocumentation(RobotEnd var) {
        switch (var) {
            case HIND: {
                return "refers to the HIND end of a robot";
            }
            case FRONT: {
                return "refers to the FRONT end of a robot";
            }
        }
        return "no documentation available";
    }

    static {
        values = RobotEnd.values();
    }

    private static class RobotEndMismatchException
    extends RuntimeException {
        private static final long serialVersionUID = -159864473420885631L;
    }
}

