/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotSide;

import java.lang.reflect.Array;
import java.util.function.Supplier;
import us.ihmc.commons.lists.SupplierBuilder;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class RecyclingQuadrantDependentList<V>
extends QuadrantDependentList<V> {
    private final V[] elementStorageForWhenNull;
    private final Supplier<V> builder;
    private final V[][] valueArrays;

    public RecyclingQuadrantDependentList(Class<V> clazz) {
        this.builder = SupplierBuilder.createFromEmptyConstructor(clazz);
        this.elementStorageForWhenNull = (Object[])Array.newInstance(clazz, 4);
        for (int i = 0; i < 4; ++i) {
            V newInstance = this.builder.get();
            this.elementStorageForWhenNull[i] = newInstance;
        }
        this.valueArrays = new Object[5][];
        this.valueArrays[0] = (Object[])Array.newInstance(clazz, 0);
        this.valueArrays[1] = (Object[])Array.newInstance(clazz, 1);
        this.valueArrays[2] = (Object[])Array.newInstance(clazz, 2);
        this.valueArrays[3] = (Object[])Array.newInstance(clazz, 3);
        this.valueArrays[4] = this.elementStorageForWhenNull;
    }

    public V add(RobotQuadrant robotQuadrant) {
        V element = this.elementStorageForWhenNull[robotQuadrant.ordinal()];
        if (element == this.get(robotQuadrant)) {
            return element;
        }
        if (element == null && this.containsQuadrant(robotQuadrant)) {
            super.set(robotQuadrant, element);
            this.fillValueArray();
            return element;
        }
        if (element != null && !this.containsQuadrant(robotQuadrant)) {
            V storageWhenNull = this.elementStorageForWhenNull[robotQuadrant.ordinal()];
            super.set(robotQuadrant, storageWhenNull);
            this.fillValueArray();
            return element;
        }
        return element;
    }

    public V remove(RobotQuadrant robotQuadrant) {
        if (this.containsQuadrant(robotQuadrant)) {
            this.elementStorageForWhenNull[robotQuadrant.ordinal()] = this.get(robotQuadrant);
            Object remove = super.remove(robotQuadrant);
            this.fillValueArray();
            return remove;
        }
        return this.get(robotQuadrant);
    }

    private void fillValueArray() {
        if (this.size() == 4) {
            return;
        }
        int j = 0;
        for (int i = 0; i < this.elementStorageForWhenNull.length; ++i) {
            if (!this.containsQuadrant(RobotQuadrant.values[i])) continue;
            this.valueArrays[this.size()][j++] = this.elementStorageForWhenNull[i];
        }
    }

    public V[] keys() {
        return this.valueArrays[this.size()];
    }

    @Override
    public void clear() {
        for (RobotQuadrant robotQuadrant : this.quadrants()) {
            this.elementStorageForWhenNull[robotQuadrant.ordinal()] = this.get(robotQuadrant);
        }
        super.clear();
    }

    public boolean containsQuadrant(RobotQuadrant robotQuadrant) {
        return this.containsKey(robotQuadrant);
    }
}

