/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import java.util.HashMap;
import org.apache.commons.lang3.mutable.MutableInt;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;

public class ReferenceFrameMissingTools {
    private static final ThreadLocal<HashMap<String, MutableInt>> INDEX = ThreadLocal.withInitial(HashMap::new);

    public static ReferenceFrame constructFrameWithUnchangingTransformFromParent(ReferenceFrame parentFrame, RigidBodyTransform transformFromParent) {
        return ReferenceFrameTools.constructFrameWithUnchangingTransformFromParent((String)ReferenceFrameMissingTools.computeFrameName(ReferenceFrameMissingTools.getCallingClassName()), (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)transformFromParent);
    }

    public static ReferenceFrame constructFrameWithUnchangingTransformToParent(ReferenceFrame parentFrame, RigidBodyTransform transformToParent) {
        return ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)ReferenceFrameMissingTools.computeFrameName(ReferenceFrameMissingTools.getCallingClassName()), (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)transformToParent);
    }

    public static ReferenceFrame constructFrameWithChangingTransformFromParent(ReferenceFrame parentFrame, RigidBodyTransform transformFromParent) {
        return ReferenceFrameTools.constructFrameWithChangingTransformFromParent((String)ReferenceFrameMissingTools.computeFrameName(ReferenceFrameMissingTools.getCallingClassName()), (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)transformFromParent);
    }

    public static ReferenceFrame constructFrameWithChangingTransformToParent(ReferenceFrame parentFrame, RigidBodyTransform transformToParent) {
        return ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)ReferenceFrameMissingTools.computeFrameName(ReferenceFrameMissingTools.getCallingClassName()), (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)transformToParent);
    }

    private static String computeFrameName(String callingClassName) {
        HashMap<String, MutableInt> threadLocalHashMap = INDEX.get();
        threadLocalHashMap.computeIfAbsent(callingClassName, key -> new MutableInt());
        int frameID = threadLocalHashMap.get(callingClassName).getAndIncrement();
        return callingClassName + frameID;
    }

    private static String getCallingClassName() {
        StackTraceElement callerStackElement = new Throwable().getStackTrace()[2];
        return callerStackElement.getClassName();
    }
}

