/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import java.util.function.Consumer;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;

public class ModifiableReferenceFrame {
    private final RigidBodyTransform transformToParent = new RigidBodyTransform();
    private final ReferenceFrame referenceFrame;

    public ModifiableReferenceFrame(ReferenceFrame parentFrame) {
        this.referenceFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent(parentFrame, this.transformToParent);
    }

    public void update(Consumer<RigidBodyTransform> transformToParentConsumer) {
        transformToParentConsumer.accept(this.transformToParent);
        this.referenceFrame.update();
    }

    public RigidBodyTransform getTransformToParent() {
        return this.transformToParent;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }
}

