/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.physics.CollisionListResult;
import us.ihmc.robotics.physics.CollisionResult;

public class MultiRobotCollisionGroup {
    private final Set<RigidBodyBasics> rootBodies = new HashSet<RigidBodyBasics>();
    private final CollisionListResult groupCollisions = new CollisionListResult();

    public void add(MultiRobotCollisionGroup other) {
        this.rootBodies.addAll(other.rootBodies);
        this.groupCollisions.addAll(other.groupCollisions);
    }

    public boolean contains(RigidBodyBasics rootBody) {
        return this.rootBodies.contains(rootBody);
    }

    public Set<RigidBodyBasics> getRootBodies() {
        return this.rootBodies;
    }

    public int getNumberOfRobots() {
        return this.rootBodies.size();
    }

    public CollisionListResult getGroupCollisions() {
        return this.groupCollisions;
    }

    public int getNumberOfCollisions() {
        return this.groupCollisions.size();
    }

    public String toString() {
        return "Root-bodies: " + this.rootBodies.toString() + ", group collisions:\n" + this.groupCollisions.toString();
    }

    public static List<MultiRobotCollisionGroup> toCollisionGroups(CollisionListResult allCollisions) {
        if (allCollisions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MultiRobotCollisionGroup> groupList = new ArrayList<MultiRobotCollisionGroup>();
        HashMap<RigidBodyBasics, MultiRobotCollisionGroup> groupMap = new HashMap<RigidBodyBasics, MultiRobotCollisionGroup>();
        for (CollisionResult collision : allCollisions) {
            MultiRobotCollisionGroup groupAB;
            MultiRobotCollisionGroup groupA;
            RigidBodyBasics rootA = collision.getCollidableA().getRootBody();
            RigidBodyBasics rootB = collision.getCollidableB().getRootBody();
            if (rootA == null) {
                MultiRobotCollisionGroup groupB = (MultiRobotCollisionGroup)groupMap.get(rootB);
                if (groupB == null) {
                    groupB = new MultiRobotCollisionGroup();
                    groupB.rootBodies.add(rootB);
                    groupMap.put(rootB, groupB);
                    groupList.add(groupB);
                }
                groupB.groupCollisions.add(collision);
                continue;
            }
            if (rootB == null) {
                groupA = (MultiRobotCollisionGroup)groupMap.get(rootA);
                if (groupA == null) {
                    groupA = new MultiRobotCollisionGroup();
                    groupA.rootBodies.add(rootA);
                    groupMap.put(rootA, groupA);
                    groupList.add(groupA);
                }
                groupA.groupCollisions.add(collision);
                continue;
            }
            groupA = (MultiRobotCollisionGroup)groupMap.get(rootA);
            MultiRobotCollisionGroup groupB = (MultiRobotCollisionGroup)groupMap.get(rootB);
            if (groupA == null) {
                if (groupB == null) {
                    groupAB = new MultiRobotCollisionGroup();
                    groupAB.rootBodies.add(rootA);
                    groupAB.rootBodies.add(rootB);
                    groupAB.groupCollisions.add(collision);
                    groupMap.put(rootA, groupAB);
                    groupMap.put(rootB, groupAB);
                    groupList.add(groupAB);
                    continue;
                }
                groupAB = groupB;
                groupAB.rootBodies.add(rootA);
                groupAB.groupCollisions.add(collision);
                groupMap.put(rootA, groupAB);
                continue;
            }
            if (groupB == null) {
                groupAB = groupA;
                groupAB.rootBodies.add(rootB);
                groupAB.groupCollisions.add(collision);
                groupMap.put(rootB, groupAB);
                continue;
            }
            if (groupA != groupB) {
                groupA.add(groupB);
                for (RigidBodyBasics root : groupB.rootBodies) {
                    groupMap.put(root, groupA);
                }
                groupList.remove(groupB);
            }
            groupA.groupCollisions.add(collision);
        }
        return groupList;
    }
}

