/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.List;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.robotics.physics.JointStateProvider;

public interface ImpulseBasedConstraintCalculator {
    public void initialize(double var1);

    public void updateInertia(List<? extends RigidBodyBasics> var1, List<? extends JointBasics> var2);

    default public void computeImpulse(double dt) {
        this.updateImpulse(dt, 1.0, true);
    }

    public void updateImpulse(double var1, double var3, boolean var5);

    default public void updateTwistModifiers() {
    }

    default public void finalizeImpulse() {
    }

    public double getImpulseUpdate();

    public double getVelocityUpdate();

    public boolean isConstraintActive();

    default public void setExternalTwistModifiers(RigidBodyTwistProvider externalRigidBodyTwistModifier, JointStateProvider externalJointTwistModifier) {
        if (externalJointTwistModifier.getState() != JointStateType.VELOCITY) {
            throw new IllegalArgumentException("Unexpect joint state providers, expected: VELOCITY, was " + externalJointTwistModifier.getState());
        }
        this.setExternalTwistModifier(externalRigidBodyTwistModifier);
        this.setExternalTwistModifier(externalJointTwistModifier);
    }

    default public void setExternalTwistModifier(RigidBodyTwistProvider externalRigidBodyTwistModifier) {
    }

    default public void setExternalTwistModifier(JointStateProvider externalJointTwistModifier) {
    }

    public int getNumberOfRobotsInvolved();

    public RigidBodyTwistProvider getRigidBodyTwistChangeProvider(int var1);

    public JointStateProvider getJointTwistChangeProvider(int var1);

    public RigidBodyBasics getRootBody(int var1);

    public DMatrixRMaj getJointVelocityChange(int var1);

    public List<? extends RigidBodyBasics> getRigidBodyTargets();

    public List<? extends JointBasics> getJointTargets();
}

