/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.occupancyGrid;

import us.ihmc.yoVariables.providers.DoubleProvider;

public class OccupancyGridCell {
    private static final int maxExpectedIndex = 10000;
    private DoubleProvider occupancyThreshold = () -> 1.0;
    private DoubleProvider occupancyDecayRate = () -> 1.0;
    private boolean isOccupied = false;
    private double numberOfHits = 0.0;
    private final int xIndex;
    private final int yIndex;
    private final int hashCode;

    public OccupancyGridCell(int xIndex, int yIndex) {
        this.xIndex = xIndex;
        this.yIndex = yIndex;
        this.hashCode = OccupancyGridCell.computeHashCode(this);
    }

    public OccupancyGridCell(int xIndex, int yIndex, DoubleProvider occupancyThreshold, DoubleProvider occupancyDecayRate) {
        this(xIndex, yIndex);
        this.setOccupancyThreshold(occupancyThreshold);
        this.setOccupancyDecayRate(occupancyDecayRate);
    }

    public boolean getIsOccupied() {
        return this.isOccupied;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    public void reset() {
        this.isOccupied = false;
        this.numberOfHits = 0.0;
    }

    public void setOccupancyThreshold(DoubleProvider occupancyThreshold) {
        this.occupancyThreshold = occupancyThreshold;
    }

    public void setOccupancyDecayRate(DoubleProvider occupancyDecayRate) {
        this.occupancyDecayRate = occupancyDecayRate;
    }

    public boolean update() {
        if (this.occupancyDecayRate.getValue() >= 1.0) {
            return this.isOccupied;
        }
        this.numberOfHits *= 1.0 - this.occupancyDecayRate.getValue();
        return this.updateOccupancyEstimate();
    }

    public boolean registerHit() {
        this.numberOfHits += 1.0;
        return this.updateOccupancyEstimate();
    }

    private boolean updateOccupancyEstimate() {
        this.isOccupied = this.numberOfHits >= this.occupancyThreshold.getValue();
        return this.isOccupied;
    }

    public static int computeHashCode(OccupancyGridCell cell) {
        return OccupancyGridCell.computeHashCode(cell.xIndex, cell.yIndex);
    }

    public static int computeHashCode(int xIndex, int yIndex) {
        int result = 1;
        int prime = 31;
        result += xIndex + 10000;
        return result += prime * (10000 + yIndex);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OccupancyGridCell other = (OccupancyGridCell)obj;
        if (this.xIndex != other.xIndex) {
            return false;
        }
        return this.yIndex == other.yIndex;
    }
}

