/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointReadOnly;

public interface SE3WaypointReadOnly
extends EuclideanWaypointReadOnly,
SO3WaypointReadOnly {
    public EuclideanWaypointReadOnly getEuclideanWaypoint();

    public SO3WaypointReadOnly getSO3Waypoint();

    @Override
    default public Point3DReadOnly getPosition() {
        return this.getEuclideanWaypoint().getPosition();
    }

    @Override
    default public QuaternionReadOnly getOrientation() {
        return this.getSO3Waypoint().getOrientation();
    }

    @Override
    default public Vector3DReadOnly getLinearVelocity() {
        return this.getEuclideanWaypoint().getLinearVelocity();
    }

    @Override
    default public Vector3DReadOnly getAngularVelocity() {
        return this.getSO3Waypoint().getAngularVelocity();
    }

    @Override
    default public boolean containsNaN() {
        return EuclideanWaypointReadOnly.super.containsNaN() || SO3WaypointReadOnly.super.containsNaN();
    }

    default public void getPose(Pose3DBasics poseToPack) {
        poseToPack.set((Tuple3DReadOnly)this.getPosition(), (Orientation3DReadOnly)this.getOrientation());
    }

    @Override
    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SE3WaypointReadOnly)) {
            return false;
        }
        SE3WaypointReadOnly other = (SE3WaypointReadOnly)geometry;
        if (!this.getEuclideanWaypoint().equals(other.getEuclideanWaypoint())) {
            return false;
        }
        return this.getSO3Waypoint().equals(other.getSO3Waypoint());
    }

    @Override
    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SE3WaypointReadOnly)) {
            return false;
        }
        SE3WaypointReadOnly other = (SE3WaypointReadOnly)geometry;
        if (!this.getEuclideanWaypoint().epsilonEquals(other.getEuclideanWaypoint(), epsilon)) {
            return false;
        }
        return this.getSO3Waypoint().epsilonEquals(other.getSO3Waypoint(), epsilon);
    }

    @Override
    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SE3WaypointReadOnly)) {
            return false;
        }
        SE3WaypointReadOnly other = (SE3WaypointReadOnly)geometry;
        if (!this.getEuclideanWaypoint().geometricallyEquals(other.getEuclideanWaypoint(), epsilon)) {
            return false;
        }
        return this.getSO3Waypoint().geometricallyEquals(other.getSO3Waypoint(), epsilon);
    }

    @Override
    default public String toString(String format) {
        return String.format("SE3 waypoint: [position=%s, orientation=%s, linear velocity=%s, angular velocity=%s]", this.getPosition().toString(format), this.getOrientation().toString(format), this.getLinearVelocity().toString(format), this.getAngularVelocity().toString(format));
    }
}

