/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.robotics.math.trajectories.waypoints.EuclideanWaypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointReadOnly;

public interface FixedFrameEuclideanWaypointBasics
extends FrameEuclideanWaypointReadOnly,
EuclideanWaypointBasics {
    public FixedFramePoint3DBasics getPosition();

    public FixedFrameVector3DBasics getLinearVelocity();

    default public void set(FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.getPosition().set((FrameTuple3DReadOnly)position);
        this.getLinearVelocity().set((FrameTuple3DReadOnly)linearVelocity);
    }

    default public void set(FrameEuclideanWaypointReadOnly other) {
        this.set(other.getReferenceFrame(), other);
    }

    default public void set(ReferenceFrame referenceFrame, EuclideanWaypointReadOnly other) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(other);
    }

    public static FixedFrameEuclideanWaypointBasics newFixedFrameEuclideanWaypointBasics(ReferenceFrameHolder referenceFrameHolder) {
        return FixedFrameEuclideanWaypointBasics.newLinkedFixedFrameEuclideanWaypointBasics(referenceFrameHolder, new EuclideanWaypoint());
    }

    public static FixedFrameEuclideanWaypointBasics newLinkedFixedFrameEuclideanWaypointBasics(final ReferenceFrameHolder referenceFrameHolder, final EuclideanWaypointBasics originalWaypoint) {
        return new FixedFrameEuclideanWaypointBasics(){
            private final FixedFramePoint3DBasics position;
            private final FixedFrameVector3DBasics linearVelocity;
            {
                this.position = EuclidFrameFactories.newLinkedFixedFramePoint3DBasics((ReferenceFrameHolder)referenceFrameHolder, (Point3DBasics)originalWaypoint.getPosition());
                this.linearVelocity = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)referenceFrameHolder, (Vector3DBasics)originalWaypoint.getLinearVelocity());
            }

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            @Override
            public FixedFramePoint3DBasics getPosition() {
                return this.position;
            }

            @Override
            public FixedFrameVector3DBasics getLinearVelocity() {
                return this.linearVelocity;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)this.getPosition(), (Object)this.getLinearVelocity());
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameEuclideanWaypointReadOnly) {
                    return this.equals((FrameEuclideanWaypointReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }
}

