/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.lists;

import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameTrajectoryPointListBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameSE3TrajectoryPointList;

public class FrameEuclideanTrajectoryPointList
implements FrameTrajectoryPointListBasics<FrameEuclideanTrajectoryPoint> {
    private ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
    private final RecyclingArrayList<FrameEuclideanTrajectoryPoint> trajectoryPoints = new RecyclingArrayList(FrameEuclideanTrajectoryPoint.class);

    @Override
    public void clear() {
        this.trajectoryPoints.clear();
    }

    public void addTrajectoryPoint(double time, Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        ((FrameEuclideanTrajectoryPoint)this.trajectoryPoints.add()).setIncludingFrame(this.getReferenceFrame(), time, position, linearVelocity);
    }

    @Override
    public void addTrajectoryPoint(FrameEuclideanTrajectoryPoint trajectoryPoint) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)trajectoryPoint);
        ((FrameEuclideanTrajectoryPoint)this.trajectoryPoints.add()).setIncludingFrame(trajectoryPoint);
    }

    @Override
    public void addTrajectoryPoint(EuclideanTrajectoryPointBasics trajectoryPoint) {
        FrameEuclideanTrajectoryPoint newTrajectoryPoint = (FrameEuclideanTrajectoryPoint)this.trajectoryPoints.add();
        newTrajectoryPoint.setToZero(this.getReferenceFrame());
        newTrajectoryPoint.set(trajectoryPoint);
    }

    public FrameEuclideanTrajectoryPoint addTrajectoryPoint() {
        return (FrameEuclideanTrajectoryPoint)this.trajectoryPoints.add();
    }

    public void setIncludingFrame(FrameSE3TrajectoryPointList trajectoryPointList) {
        this.clear(trajectoryPointList.getReferenceFrame());
        for (int i = 0; i < trajectoryPointList.getNumberOfTrajectoryPoints(); ++i) {
            this.addTrajectoryPoint(trajectoryPointList.getTrajectoryPoint(i));
        }
    }

    @Override
    public FrameEuclideanTrajectoryPoint getTrajectoryPoint(int trajectoryPointIndex) {
        return (FrameEuclideanTrajectoryPoint)this.trajectoryPoints.get(trajectoryPointIndex);
    }

    @Override
    public int getNumberOfTrajectoryPoints() {
        return this.trajectoryPoints.size();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
        for (int i = 0; i < this.trajectoryPoints.size(); ++i) {
            ((FrameEuclideanTrajectoryPoint)this.trajectoryPoints.get(i)).setReferenceFrame(referenceFrame);
        }
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public String toString() {
        return "Frame Euclidean trajectory: number of frame Euclidean trajectory points = " + this.getNumberOfTrajectoryPoints() + ".";
    }
}

