/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointReadOnly;

public interface SO3TrajectoryPointReadOnly
extends TrajectoryPointReadOnly,
SO3WaypointReadOnly {
    @Override
    default public boolean containsNaN() {
        return this.isTimeNaN() || SO3WaypointReadOnly.super.containsNaN();
    }

    @Override
    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SO3TrajectoryPointReadOnly)) {
            return false;
        }
        SO3TrajectoryPointReadOnly other = (SO3TrajectoryPointReadOnly)geometry;
        if (!EuclidCoreTools.equals((double)this.getTime(), (double)other.getTime())) {
            return false;
        }
        if (!this.getOrientation().equals((EuclidGeometry)other.getOrientation())) {
            return false;
        }
        return this.getAngularVelocity().equals((EuclidGeometry)other.getAngularVelocity());
    }

    @Override
    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SO3TrajectoryPointReadOnly)) {
            return false;
        }
        SO3TrajectoryPointReadOnly other = (SO3TrajectoryPointReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon)) {
            return false;
        }
        if (!this.getOrientation().epsilonEquals((EuclidGeometry)other.getOrientation(), epsilon)) {
            return false;
        }
        return this.getAngularVelocity().epsilonEquals((EuclidGeometry)other.getAngularVelocity(), epsilon);
    }

    @Override
    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SO3TrajectoryPointReadOnly)) {
            return false;
        }
        SO3TrajectoryPointReadOnly other = (SO3TrajectoryPointReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon)) {
            return false;
        }
        if (!this.getOrientation().geometricallyEquals((EuclidGeometry)other.getOrientation(), epsilon)) {
            return false;
        }
        return this.getAngularVelocity().geometricallyEquals((EuclidGeometry)other.getAngularVelocity(), epsilon);
    }

    @Override
    default public String toString(String format) {
        return String.format("SO3 trajectory point: [time=%s, orientation=%s, angular velocity=%s]", EuclidCoreIOTools.getStringOf(null, (String)format, (double[])new double[]{this.getTime()}), EuclidCoreIOTools.getTuple4DString((String)format, (Tuple4DReadOnly)this.getOrientation()), EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)this.getAngularVelocity()));
    }
}

