/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.YoFrameSO3Waypoint;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameSO3TrajectoryPoint
implements FrameSO3TrajectoryPointBasics {
    private final YoFrameSO3Waypoint so3Waypoint;
    private final YoDouble time;
    private final String namePrefix;
    private final String nameSuffix;

    public YoFrameSO3TrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.so3Waypoint = new YoFrameSO3Waypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
    }

    public YoFrameSO3TrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame) {
        this.so3Waypoint = new YoFrameSO3Waypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.setToZero(referenceFrame);
    }

    @Override
    public FixedFrameQuaternionBasics getOrientation() {
        return this.so3Waypoint.getOrientation();
    }

    @Override
    public FixedFrameVector3DBasics getAngularVelocity() {
        return this.so3Waypoint.getAngularVelocity();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.so3Waypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.so3Waypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time.set(time);
    }

    @Override
    public double getTime() {
        return this.time.getValue();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getOrientation(), (Object)this.getAngularVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameSO3TrajectoryPointReadOnly) {
            return this.equals((FrameSO3TrajectoryPointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

