/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.FrameSE3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameSO3WaypointBasics;

public class FrameSE3TrajectoryPoint
implements FrameSE3TrajectoryPointBasics {
    private final FrameSE3Waypoint se3Waypoint = new FrameSE3Waypoint();
    private double time;

    public FrameSE3TrajectoryPoint() {
    }

    public FrameSE3TrajectoryPoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameSE3TrajectoryPoint(double time, FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly linearVelocity, FrameVector3DReadOnly angularVelocity) {
        this.setIncludingFrame(time, position, orientation, linearVelocity, angularVelocity);
    }

    public FrameSE3TrajectoryPoint(FrameSE3TrajectoryPointBasics other) {
        this.setIncludingFrame(other);
    }

    public FrameSE3TrajectoryPoint(ReferenceFrame referenceFrame, SE3TrajectoryPointReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
    }

    @Override
    public FixedFrameEuclideanWaypointBasics getEuclideanWaypoint() {
        return this.se3Waypoint.getEuclideanWaypoint();
    }

    @Override
    public FixedFrameSO3WaypointBasics getSO3Waypoint() {
        return this.se3Waypoint.getSO3Waypoint();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.se3Waypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.se3Waypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time = time;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getEuclideanWaypoint(), (Object)this.getSO3Waypoint());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameSE3TrajectoryPointReadOnly) {
            return this.equals((FrameSE3TrajectoryPointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

