/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.commons.lists.SupplierBuilder;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeMatrix;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;

public class MultiSpline1DSolver {
    public static final int defaultCoefficients = 4;
    private final RecyclingArrayList<WaypointData> waypoints = new RecyclingArrayList(SupplierBuilder.indexedSupplier(x$0 -> new WaypointData(x$0)));
    private final RecyclingArrayList<Spline1DSegment> splineSegments = new RecyclingArrayList(SupplierBuilder.indexedSupplier(x$0 -> new Spline1DSegment(x$0)));
    private final NativeMatrix H_minAccel = new NativeMatrix(1, 1);
    private final DMatrixRMaj H = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj f = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj A = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj ATranspose = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj b = new DMatrixRMaj(1, 1);
    private int lastSize = 1;
    private final NativeMatrix E = new NativeMatrix(1, 1);
    private final NativeMatrix d = new NativeMatrix(1, 1);
    private final NativeMatrix nativeSolution = new NativeMatrix(1, 1);
    private final DMatrixRMaj solution = new DMatrixRMaj(1, 1);

    public void clearWaypoints() {
        int i;
        for (i = 0; i < this.waypoints.size(); ++i) {
            ((WaypointData)this.waypoints.get(i)).clear();
        }
        this.waypoints.clear();
        for (i = 0; i < this.splineSegments.size(); ++i) {
            ((Spline1DSegment)this.splineSegments.get(i)).clear();
        }
        this.splineSegments.clear();
    }

    public WaypointData addWaypoint() {
        if (!this.waypoints.isEmpty()) {
            ((Spline1DSegment)this.splineSegments.add()).update();
        }
        return (WaypointData)this.waypoints.add();
    }

    public WaypointData addWaypointPosition(double time, double position) {
        if (!this.waypoints.isEmpty() && time <= ((WaypointData)this.waypoints.getLast()).t) {
            throw new IllegalArgumentException("The given time is not greater than the previous waypoint: time=" + time + ", previous waypoint time=" + ((WaypointData)this.waypoints.getLast()).t);
        }
        WaypointData waypoint = this.addWaypoint();
        waypoint.set(time, position);
        return waypoint;
    }

    public WaypointData addWaypointPosition(double time, double position, double weight) {
        if (!this.waypoints.isEmpty() && time <= ((WaypointData)this.waypoints.getLast()).t) {
            throw new IllegalArgumentException("The given time is not greater than the previous waypoint: time=" + time + ", previous waypoint time=" + ((WaypointData)this.waypoints.getLast()).t);
        }
        WaypointData waypoint = this.addWaypoint();
        waypoint.set(time, position);
        waypoint.setPositionWeight(weight);
        return waypoint;
    }

    public WaypointData addWaypoint(double time, double position, double velocity) {
        if (!this.waypoints.isEmpty() && time <= ((WaypointData)this.waypoints.getLast()).t) {
            throw new IllegalArgumentException("The given time is not greater than the previous waypoint: time=" + time + ", previous waypoint time=" + ((WaypointData)this.waypoints.getLast()).t);
        }
        WaypointData waypoint = this.addWaypoint();
        waypoint.set(time, position, velocity);
        return waypoint;
    }

    public double solveAndComputeCost() {
        this.solve();
        return this.integratedAccelerationSquared();
    }

    public void solve() {
        if (this.waypoints.size() < 2) {
            throw new IllegalStateException("Not enough waypoints.");
        }
        this.buildCostFunction(this.H_minAccel, this.H, this.f);
        this.buildKnotEqualityConstraints(this.A, this.b);
        int subProblemSize = this.getProblemSize();
        int constraints = this.computeNumberOfEqualityConstraints();
        int size = subProblemSize + constraints;
        if (this.lastSize != size) {
            this.E.reshape(size, size);
            this.d.reshape(size, 1);
            this.E.zero();
            this.lastSize = size;
        }
        this.E.insert(this.H, 0, 0);
        this.E.insert(this.A, subProblemSize, 0);
        this.ATranspose.reshape(this.A.getNumCols(), this.A.getNumRows());
        CommonOps_DDRM.transpose((DMatrixRMaj)this.A, (DMatrixRMaj)this.ATranspose);
        this.E.insert(this.ATranspose, 0, subProblemSize);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.f);
        this.d.insert(this.f, 0, 0);
        this.d.insert(this.b, subProblemSize, 0);
        this.nativeSolution.solve(this.E, this.d);
        this.nativeSolution.reshape(subProblemSize, 1);
        this.nativeSolution.get(this.solution);
    }

    public DMatrixRMaj getSolution() {
        return this.solution;
    }

    public double integratedAccelerationSquared() {
        this.d.multQuad(this.nativeSolution, this.H_minAccel);
        return 0.5 * this.d.get(0, 0);
    }

    public int getProblemSize() {
        int size = 0;
        for (int i = 0; i < this.splineSegments.size(); ++i) {
            size += ((Spline1DSegment)this.splineSegments.get(i)).getNumberOfCoefficients();
        }
        return size;
    }

    private void buildKnotEqualityConstraints(DMatrixRMaj A, DMatrixRMaj b) {
        int constraints = this.computeNumberOfEqualityConstraints();
        int subProblemSize = this.getProblemSize();
        A.reshape(constraints, subProblemSize);
        b.reshape(constraints, 1);
        CommonOps_DDRM.fill((DMatrixD1)A, (double)0.0);
        int constraintIndex = 0;
        for (int i = 0; i < this.waypoints.size(); ++i) {
            WaypointData waypoint = (WaypointData)this.waypoints.get(i);
            constraintIndex = waypoint.w == Double.POSITIVE_INFINITY ? MultiSpline1DSolver.addDesiredWaypointPositionConstraint(waypoint, constraintIndex, A, b) : MultiSpline1DSolver.addPositionContinuityConstraint(waypoint, constraintIndex, A, b);
            constraintIndex = waypoint.wd == Double.POSITIVE_INFINITY ? MultiSpline1DSolver.addDesiredWaypointVelocityConstraint(waypoint, constraintIndex, A, b) : MultiSpline1DSolver.addVelocityContinuityConstraint(waypoint, constraintIndex, A, b);
        }
    }

    static int addPositionContinuityConstraint(WaypointData waypoint, int constraintIndex, DMatrixRMaj A, DMatrixRMaj b) {
        Spline1DSegment spline0 = waypoint.getPreviousSpline();
        Spline1DSegment spline1 = waypoint.getNextSpline();
        if (spline0 == null || spline1 == null) {
            return constraintIndex;
        }
        int nCoeffs0 = spline0.getNumberOfCoefficients();
        int nCoeffs1 = spline1.getNumberOfCoefficients();
        int i0 = spline0.getIndexFirstCoefficient();
        int i1 = spline1.getIndexFirstCoefficient();
        double t = waypoint.t;
        MultiSpline1DSolver.getPositionConstraintABlock(t, nCoeffs0, constraintIndex, i0, A);
        if (nCoeffs0 == nCoeffs1) {
            MatrixTools.setMatrixBlock((DMatrix)A, (int)constraintIndex, (int)i1, (DMatrix)A, (int)constraintIndex, (int)i0, (int)1, (int)nCoeffs0, (double)-1.0);
        } else {
            MultiSpline1DSolver.getPositionConstraintABlock(t, nCoeffs1, true, constraintIndex, i1, A);
        }
        b.set(constraintIndex, 0.0);
        return constraintIndex + 1;
    }

    static int addVelocityContinuityConstraint(WaypointData waypoint, int constraintIndex, DMatrixRMaj A, DMatrixRMaj b) {
        Spline1DSegment spline0 = waypoint.getPreviousSpline();
        Spline1DSegment spline1 = waypoint.getNextSpline();
        if (spline0 == null || spline1 == null) {
            return constraintIndex;
        }
        int i0 = spline0.getIndexFirstCoefficient();
        int i1 = spline1.getIndexFirstCoefficient();
        int n0 = spline0.getNumberOfCoefficients();
        int n1 = spline1.getNumberOfCoefficients();
        double t = waypoint.t;
        MultiSpline1DSolver.getVelocityConstraintABlock(t, n0, constraintIndex, i0, A);
        if (n0 == n1) {
            MatrixTools.setMatrixBlock((DMatrix)A, (int)constraintIndex, (int)i1, (DMatrix)A, (int)constraintIndex, (int)i0, (int)1, (int)n0, (double)-1.0);
        } else {
            MultiSpline1DSolver.getVelocityConstraintABlock(t, n1, true, constraintIndex, i1, A);
        }
        b.set(constraintIndex, 0.0);
        return constraintIndex + 1;
    }

    static int addDesiredWaypointPositionConstraint(WaypointData waypoint, int constraintIndex, DMatrixRMaj A, DMatrixRMaj b) {
        Spline1DSegment spline0 = waypoint.getPreviousSpline();
        Spline1DSegment spline1 = waypoint.getNextSpline();
        double t = waypoint.t;
        double x = waypoint.x;
        int i0 = -1;
        int n0 = -1;
        if (spline0 != null) {
            i0 = spline0.getIndexFirstCoefficient();
            n0 = spline0.getNumberOfCoefficients();
            MultiSpline1DSolver.getPositionConstraintABlock(t, n0, constraintIndex, i0, A);
            b.set(constraintIndex, x);
            ++constraintIndex;
        }
        if (spline1 != null) {
            int i1 = spline1.getIndexFirstCoefficient();
            int n1 = spline1.getNumberOfCoefficients();
            if (n1 == n0) {
                CommonOps_DDRM.extract((DMatrix)A, (int)(constraintIndex - 1), (int)constraintIndex, (int)i0, (int)i1, (DMatrix)A, (int)constraintIndex, (int)i1);
            } else {
                MultiSpline1DSolver.getPositionConstraintABlock(t, n1, constraintIndex, i1, A);
            }
            b.set(constraintIndex, x);
            ++constraintIndex;
        }
        return constraintIndex;
    }

    static int addDesiredWaypointVelocityConstraint(WaypointData waypoint, int constraintIndex, DMatrixRMaj A, DMatrixRMaj b) {
        Spline1DSegment spline0 = waypoint.getPreviousSpline();
        Spline1DSegment spline1 = waypoint.getNextSpline();
        double t = waypoint.t;
        double xd = waypoint.xd;
        int i0 = -1;
        int n0 = -1;
        if (spline0 != null) {
            i0 = spline0.getIndexFirstCoefficient();
            n0 = spline0.getNumberOfCoefficients();
            MultiSpline1DSolver.getVelocityConstraintABlock(t, n0, constraintIndex, i0, A);
            b.set(constraintIndex, xd);
            ++constraintIndex;
        }
        if (spline1 != null) {
            int i1 = spline1.getIndexFirstCoefficient();
            int n1 = spline1.getNumberOfCoefficients();
            if (n1 == n0) {
                CommonOps_DDRM.extract((DMatrix)A, (int)(constraintIndex - 1), (int)constraintIndex, (int)i0, (int)i1, (DMatrix)A, (int)constraintIndex, (int)i1);
            } else {
                MultiSpline1DSolver.getVelocityConstraintABlock(t, n1, constraintIndex, i1, A);
            }
            b.set(constraintIndex, xd);
            ++constraintIndex;
        }
        return constraintIndex;
    }

    private int computeNumberOfEqualityConstraints() {
        int constraints = 0;
        WaypointData waypoint = (WaypointData)this.waypoints.getFirst();
        if (waypoint.w == Double.POSITIVE_INFINITY) {
            ++constraints;
        }
        if (waypoint.wd == Double.POSITIVE_INFINITY) {
            ++constraints;
        }
        for (int i = 1; i < this.waypoints.size() - 1; ++i) {
            waypoint = (WaypointData)this.waypoints.get(i);
            constraints = waypoint.w == Double.POSITIVE_INFINITY ? (constraints += 2) : ++constraints;
            if (waypoint.wd == Double.POSITIVE_INFINITY) {
                constraints += 2;
                continue;
            }
            ++constraints;
        }
        waypoint = (WaypointData)this.waypoints.getLast();
        if (waypoint.w == Double.POSITIVE_INFINITY) {
            ++constraints;
        }
        if (waypoint.wd == Double.POSITIVE_INFINITY) {
            ++constraints;
        }
        return constraints;
    }

    private void buildCostFunction(NativeMatrix H_minAccel, DMatrixRMaj H, DMatrixRMaj f) {
        int size = this.getProblemSize();
        f.reshape(size, 1);
        f.zero();
        H.reshape(size, size);
        H.zero();
        this.getMinAccelerationCostFunction(H);
        H_minAccel.set(H);
        this.addKnotsCostFunction(H, f);
    }

    private void getMinAccelerationCostFunction(DMatrixRMaj H) {
        int splineOffset = 0;
        for (int i = 0; i < this.waypoints.size() - 1; ++i) {
            WaypointData w0 = (WaypointData)this.waypoints.get(i);
            WaypointData w1 = (WaypointData)this.waypoints.get(i + 1);
            Spline1DSegment spline = w0.getNextSpline();
            MultiSpline1DSolver.getMinAccelerationHBlock(w0.t, w1.t, spline.numberOfCoefficients, splineOffset, splineOffset, H);
            splineOffset += spline.numberOfCoefficients;
        }
    }

    private void addKnotsCostFunction(DMatrixRMaj H, DMatrixRMaj f) {
        for (int i = 0; i < this.waypoints.size(); ++i) {
            WaypointData waypoint = (WaypointData)this.waypoints.get(i);
            if (waypoint.w != Double.POSITIVE_INFINITY && waypoint.w > 0.0) {
                MultiSpline1DSolver.addDesiredWaypointPositionObjective(waypoint, H, f);
            }
            if (waypoint.wd == Double.POSITIVE_INFINITY || !(waypoint.wd > 0.0)) continue;
            MultiSpline1DSolver.addDesiredWaypointVelocityObjective(waypoint, H, f);
        }
    }

    static void addDesiredWaypointPositionObjective(WaypointData waypoint, DMatrixRMaj H, DMatrixRMaj f) {
        Spline1DSegment spline = waypoint.getNextSpline();
        if (spline == null) {
            spline = waypoint.getPreviousSpline();
        }
        int i = spline.getIndexFirstCoefficient();
        int n = spline.getNumberOfCoefficients();
        MultiSpline1DSolver.addPositionObjective(waypoint.t, waypoint.x, waypoint.w, n, i, i, H, f);
    }

    static void addDesiredWaypointVelocityObjective(WaypointData waypoint, DMatrixRMaj H, DMatrixRMaj f) {
        Spline1DSegment spline = waypoint.getNextSpline();
        if (spline == null) {
            spline = waypoint.getPreviousSpline();
        }
        int i = spline.getIndexFirstCoefficient();
        int n = spline.getNumberOfCoefficients();
        MultiSpline1DSolver.addVelocityObjective(waypoint.t, waypoint.xd, waypoint.wd, n, i, i, H, f);
    }

    public double computePosition(double time) {
        time = MathTools.clamp((double)time, (double)((WaypointData)this.waypoints.getFirst()).t, (double)((WaypointData)this.waypoints.getLast()).t);
        return this.findSplineSegment(time).computePosition(time);
    }

    public double computeVelocity(double time) {
        time = MathTools.clamp((double)time, (double)((WaypointData)this.waypoints.getFirst()).t, (double)((WaypointData)this.waypoints.getLast()).t);
        return this.findSplineSegment(time).computeVelocity(time);
    }

    public double computeAcceleration(double time) {
        time = MathTools.clamp((double)time, (double)((WaypointData)this.waypoints.getFirst()).t, (double)((WaypointData)this.waypoints.getLast()).t);
        return this.findSplineSegment(time).computeAcceleration(time);
    }

    public int getNumberOfWaypoints() {
        return this.waypoints.size();
    }

    public WaypointData getWaypoint(int index) {
        return (WaypointData)this.waypoints.get(index);
    }

    public WaypointData getFirstWaypoint() {
        return (WaypointData)this.waypoints.getFirst();
    }

    public WaypointData getLastWaypoint() {
        return (WaypointData)this.waypoints.getLast();
    }

    public RecyclingArrayList<WaypointData> getWaypoints() {
        return this.waypoints;
    }

    public Spline1DSegment findSplineSegment(double time) {
        if (time < ((Spline1DSegment)this.splineSegments.getFirst()).getStart().t) {
            return null;
        }
        for (int i = 0; i < this.splineSegments.size(); ++i) {
            Spline1DSegment segment = (Spline1DSegment)this.splineSegments.get(i);
            if (!(time <= segment.getEnd().t)) continue;
            return segment;
        }
        return null;
    }

    public Spline1DSegment getSplineSegment(int index) {
        return (Spline1DSegment)this.splineSegments.get(index);
    }

    static void getPositionConstraintABlock(double t, int numberOfCoefficients, int row, int startColumn, DMatrixRMaj A) {
        MultiSpline1DSolver.getPositionConstraintABlock(t, numberOfCoefficients, false, row, startColumn, A);
    }

    static void getPositionConstraintABlock(double t, int numberOfCoefficients, boolean negate, int row, int startColumn, DMatrixRMaj A) {
        double tpow = negate ? -1.0 : 1.0;
        int column = startColumn + numberOfCoefficients - 1;
        for (int i = 0; i < numberOfCoefficients; ++i) {
            A.set(row, column--, tpow);
            tpow *= t;
        }
    }

    static void getVelocityConstraintABlock(double t, int numberOfCoefficients, int row, int startColumn, DMatrixRMaj A) {
        MultiSpline1DSolver.getVelocityConstraintABlock(t, numberOfCoefficients, false, row, startColumn, A);
    }

    static void getVelocityConstraintABlock(double t, int numberOfCoefficients, boolean negate, int row, int startColumn, DMatrixRMaj A) {
        double tpow = negate ? -1.0 : 1.0;
        int column = startColumn + numberOfCoefficients - 2;
        for (int i = 1; i < numberOfCoefficients; ++i) {
            A.set(row, column--, (double)i * tpow);
            tpow *= t;
        }
    }

    static void getMinAccelerationHBlock(double t0, double t1, int numberOfCoefficients, int startRow, int startColumn, DMatrixRMaj H) {
        if (numberOfCoefficients == 4) {
            double t0pow = t0;
            double t1pow = t1;
            H.set(startRow + 1, startColumn + 1, 4.0 * (t1pow - t0pow));
            H.set(startRow + 1, startColumn + 0, 6.0 * ((t1pow *= t1) - (t0pow *= t0)));
            H.set(startRow + 0, startColumn + 1, 6.0 * (t1pow - t0pow));
            H.set(startRow + 0, startColumn + 0, 12.0 * ((t1pow *= t1) - (t0pow *= t0)));
        } else if (numberOfCoefficients == 3) {
            H.set(startRow, startColumn, 4.0 * (t1 - t0));
        } else if (numberOfCoefficients > 2) {
            throw new UnsupportedOperationException("Implement me for the following number of coefficients: " + numberOfCoefficients);
        }
    }

    static void addPositionObjective(double t, double x, double weight, int numberOfCoefficients, int startRow, int startColumn, DMatrixRMaj H, DMatrixRMaj f) {
        double tpow = weight;
        int numberOfDiagonals = 2 * numberOfCoefficients - 1;
        for (int diagonal = numberOfDiagonals - 1; diagonal >= 0; --diagonal) {
            int offsetCol = Math.max(0, diagonal - numberOfCoefficients + 1);
            int offsetRow = Math.min(diagonal, numberOfCoefficients - 1);
            int size = MultiSpline1DSolver.min(diagonal + 1, numberOfCoefficients - offsetCol, numberOfCoefficients);
            for (int i = 0; i < size; ++i) {
                H.add(startRow + offsetRow, startColumn + offsetCol, tpow);
                --offsetRow;
                ++offsetCol;
            }
            tpow *= t;
        }
        int f_index = startRow + numberOfCoefficients - 1;
        tpow = -weight * x;
        for (int i = 0; i < numberOfCoefficients; ++i) {
            f.add(f_index--, 0, tpow);
            tpow *= t;
        }
    }

    static void addVelocityObjective(double t, double xd, double weight, int numberOfCoefficients, int startRow, int startColumn, DMatrixRMaj H, DMatrixRMaj f) {
        double tpow = weight;
        int blockSize = numberOfCoefficients - 1;
        int numberOfDiagonals = 2 * blockSize - 1;
        for (int diagonal = numberOfDiagonals - 1; diagonal >= 0; --diagonal) {
            int offsetCol = Math.max(0, diagonal - blockSize + 1);
            int offsetRow = Math.min(diagonal, blockSize - 1);
            int size = MultiSpline1DSolver.min(diagonal + 1, blockSize - offsetCol, blockSize);
            for (int i = 0; i < size; ++i) {
                double scale = (blockSize - offsetRow) * (blockSize - offsetCol);
                H.add(startRow + offsetRow, startColumn + offsetCol, scale * tpow);
                --offsetRow;
                ++offsetCol;
            }
            tpow *= t;
        }
        int f_index = startRow + blockSize - 1;
        tpow = -weight * xd;
        for (int i = 0; i < blockSize; ++i) {
            f.add(f_index--, 0, (double)(i + 1) * tpow);
            tpow *= t;
        }
    }

    public static final int min(int a, int b, int c) {
        if (a < b) {
            return a < c ? a : c;
        }
        return b < c ? b : c;
    }

    public static void main(String[] args) {
        int numberOfDiagonals;
        int numberOfCoefficients = 4;
        DMatrixRMaj d = new DMatrixRMaj(4, 4);
        for (int diagonal = numberOfDiagonals = 2 * numberOfCoefficients - 1; diagonal >= 0; --diagonal) {
            int offsetCol = Math.max(0, diagonal - numberOfCoefficients + 1);
            int offsetRow = Math.min(diagonal, numberOfCoefficients - 1);
            int size = MultiSpline1DSolver.min(diagonal + 1, numberOfCoefficients - offsetCol, numberOfCoefficients);
            for (int i = 0; i < size; ++i) {
                System.out.println(offsetRow + ", " + offsetCol + ", " + size);
                d.set(offsetRow, offsetCol, (double)diagonal);
                --offsetRow;
                ++offsetCol;
            }
        }
        System.out.println(d);
    }

    public class WaypointData {
        private final int index;
        private double t;
        private double x;
        private double xd;
        private double w;
        private double wd;

        private WaypointData(int index) {
            this.index = index;
            this.clear();
        }

        public void clear() {
            this.t = Double.NaN;
            this.clearPosition();
            this.clearVelocity();
        }

        public void clearPosition() {
            this.x = Double.NaN;
            this.w = 0.0;
        }

        public void clearVelocity() {
            this.xd = Double.NaN;
            this.wd = 0.0;
        }

        public void set(double time, double position) {
            this.set(time, position, Double.NaN, Double.POSITIVE_INFINITY, 0.0);
        }

        public void set(double time, double position, double velocity) {
            this.set(time, position, velocity, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        public void set(double time, double position, double velocity, double positionWeight, double velocityWeight) {
            this.t = time;
            this.x = position;
            this.xd = velocity;
            this.setPositionWeight(positionWeight);
            this.setVelocityWeight(velocityWeight);
        }

        public void setPosition(double position) {
            this.x = position;
        }

        public void setPositionWeight(double positionWeight) {
            WaypointData.checkWeightValue(positionWeight);
            this.w = positionWeight;
        }

        public void setVelocity(double velocity) {
            this.xd = velocity;
        }

        public void setVelocityWeight(double velocityWeight) {
            WaypointData.checkWeightValue(velocityWeight);
            this.wd = velocityWeight;
        }

        private static void checkWeightValue(double weight) {
            if (weight < 0.0) {
                throw new IllegalArgumentException("A weight should be in [0, +Infinity[, was: " + weight);
            }
        }

        public int getIndex() {
            return this.index;
        }

        public double getTime() {
            return this.t;
        }

        public double getPosition() {
            return this.x;
        }

        public double getVelocity() {
            return this.xd;
        }

        public double getPositionWeight() {
            return this.w;
        }

        public double getVelocityWeight() {
            return this.wd;
        }

        public boolean hasNext() {
            return this.index < MultiSpline1DSolver.this.waypoints.size() - 1;
        }

        public WaypointData next() {
            if (this.hasNext()) {
                return (WaypointData)MultiSpline1DSolver.this.waypoints.get(this.index + 1);
            }
            return null;
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public WaypointData previous() {
            if (this.hasPrevious()) {
                return (WaypointData)MultiSpline1DSolver.this.waypoints.get(this.index - 1);
            }
            return null;
        }

        public Spline1DSegment getNextSpline() {
            if (this.index < MultiSpline1DSolver.this.splineSegments.size()) {
                return (Spline1DSegment)MultiSpline1DSolver.this.splineSegments.get(this.index);
            }
            return null;
        }

        public Spline1DSegment getPreviousSpline() {
            if (this.hasPrevious()) {
                return this.previous().getNextSpline();
            }
            return null;
        }

        public String toString() {
            return "[index=" + this.index + ", t=" + this.t + ", x=" + this.x + ", xd=" + this.xd + ", w=" + this.w + ", wd=" + this.wd + "]";
        }
    }

    public class Spline1DSegment {
        private final int index;
        private int indexFirstCoefficient;
        private int numberOfCoefficients;

        public Spline1DSegment(int index) {
            this.index = index;
            this.clear();
        }

        private void clear() {
            this.indexFirstCoefficient = -1;
            this.numberOfCoefficients = 4;
        }

        private void update() {
            this.indexFirstCoefficient = 0;
            Spline1DSegment previous = this.previous();
            if (previous != null) {
                previous.update();
                this.indexFirstCoefficient = previous.getIndexFirstCoefficient() + previous.getNumberOfCoefficients();
            }
        }

        public void setNumberOfCoefficients(int numberOfCoefficients) {
            this.numberOfCoefficients = numberOfCoefficients;
            ((Spline1DSegment)MultiSpline1DSolver.this.splineSegments.getLast()).update();
        }

        public WaypointData getStart() {
            return (WaypointData)MultiSpline1DSolver.this.waypoints.get(this.index);
        }

        public WaypointData getEnd() {
            return (WaypointData)MultiSpline1DSolver.this.waypoints.get(this.index + 1);
        }

        public double getCoefficient(int i) {
            if (i < 0 || i >= this.getNumberOfCoefficients()) {
                throw new IllegalArgumentException("Index out of bounds: " + i + " should be in [0," + this.getNumberOfCoefficients() + "[.");
            }
            return MultiSpline1DSolver.this.solution.get(this.indexFirstCoefficient + i);
        }

        public int getIndexFirstCoefficient() {
            return this.indexFirstCoefficient;
        }

        public int getNumberOfCoefficients() {
            return this.numberOfCoefficients;
        }

        public double computePosition(double time) {
            time = MathTools.clamp((double)time, (double)this.getStart().t, (double)this.getEnd().t);
            int coefficientIndex = this.indexFirstCoefficient + this.getNumberOfCoefficients() - 1;
            double tPower = 1.0;
            double x = 0.0;
            for (int i = 0; i < this.getNumberOfCoefficients(); ++i) {
                x += MultiSpline1DSolver.this.solution.get(coefficientIndex--) * tPower;
                tPower *= time;
            }
            return x;
        }

        public double computeVelocity(double time) {
            time = MathTools.clamp((double)time, (double)this.getStart().t, (double)this.getEnd().t);
            int coefficientIndex = this.indexFirstCoefficient + this.getNumberOfCoefficients() - 2;
            double tPower = 1.0;
            double xd = 0.0;
            for (int i = 1; i < this.getNumberOfCoefficients(); ++i) {
                xd += MultiSpline1DSolver.this.solution.get(coefficientIndex--) * tPower * (double)i;
                tPower *= time;
            }
            return xd;
        }

        public double computeAcceleration(double time) {
            time = MathTools.clamp((double)time, (double)this.getStart().t, (double)this.getEnd().t);
            int coefficientIndex = this.indexFirstCoefficient + this.getNumberOfCoefficients() - 3;
            double tPower = 1.0;
            double xdd = 0.0;
            for (int i = 2; i < this.getNumberOfCoefficients(); ++i) {
                xdd += MultiSpline1DSolver.this.solution.get(coefficientIndex--) * tPower * (double)i * ((double)i - 1.0);
                tPower *= time;
            }
            return xdd;
        }

        public void getPolynomial(PolynomialBasics polynomialToPack) {
            polynomialToPack.setDirectlyReverse(MultiSpline1DSolver.this.solution, this.indexFirstCoefficient, this.getNumberOfCoefficients());
        }

        public boolean hasNext() {
            return this.index < MultiSpline1DSolver.this.splineSegments.size() - 1;
        }

        public Spline1DSegment next() {
            if (this.hasNext()) {
                return (Spline1DSegment)MultiSpline1DSolver.this.splineSegments.get(this.index + 1);
            }
            return null;
        }

        public boolean hasPrevious() {
            return this.index > 0;
        }

        public Spline1DSegment previous() {
            if (this.hasPrevious()) {
                return (Spline1DSegment)MultiSpline1DSolver.this.splineSegments.get(this.index - 1);
            }
            return null;
        }

        public String toString() {
            return "[index=" + this.index + ", numberOfCoefficients=" + this.numberOfCoefficients + "]";
        }
    }
}

