/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.robotics.trajectories.providers.FramePositionProvider;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class StraightLinePositionTrajectoryGenerator
implements FixedFramePositionTrajectoryGenerator {
    protected final YoRegistry registry;
    private final ReferenceFrame referenceFrame;
    private final YoDouble currentTime;
    private final YoFramePoint3D currentPosition;
    private final YoFrameVector3D currentVelocity;
    private final YoFrameVector3D currentAcceleration;
    private final YoDouble trajectoryTime;
    private final YoPolynomial parameterPolynomial;
    private final YoFramePoint3D initialPosition;
    private final YoFramePoint3D finalPosition;
    private final YoFrameVector3D differenceVector;
    private final FramePositionProvider initialPositionProvider;
    private final FramePositionProvider finalPositionProvider;
    private final YoBoolean continuouslyUpdateFinalPosition;
    private final DoubleProvider trajectoryTimeProvider;

    public StraightLinePositionTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, DoubleProvider trajectoryTimeProvider, FramePositionProvider initialPositionProvider, FramePositionProvider finalPositionProvider, YoRegistry parentRegistry) {
        this.referenceFrame = referenceFrame;
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.trajectoryTime = new YoDouble(namePrefix + "TrajectoryTime", this.registry);
        this.currentTime = new YoDouble(namePrefix + "CurrentTime", this.registry);
        this.currentPosition = new YoFramePoint3D(namePrefix + "CurrentPosition", referenceFrame, this.registry);
        this.currentVelocity = new YoFrameVector3D(namePrefix + "CurrentVelocity", referenceFrame, this.registry);
        this.currentAcceleration = new YoFrameVector3D(namePrefix + "CurrentAcceleration", referenceFrame, this.registry);
        this.differenceVector = new YoFrameVector3D(namePrefix + "DifferenceVector", referenceFrame, this.registry);
        this.parameterPolynomial = new YoPolynomial(namePrefix + "ParameterPolynomial", 6, this.registry);
        this.initialPosition = new YoFramePoint3D(namePrefix + "InitialPos", referenceFrame, this.registry);
        this.finalPosition = new YoFramePoint3D(namePrefix + "FinalPos", referenceFrame, this.registry);
        this.continuouslyUpdateFinalPosition = new YoBoolean(namePrefix + "ContinuouslyUpdate", this.registry);
        this.initialPositionProvider = initialPositionProvider;
        this.finalPositionProvider = finalPositionProvider;
        this.trajectoryTimeProvider = trajectoryTimeProvider;
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void initialize() {
        this.currentTime.set(0.0);
        this.trajectoryTime.set(this.trajectoryTimeProvider.getValue());
        this.parameterPolynomial.setQuintic(0.0, this.trajectoryTime.getDoubleValue(), 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.updateInitialPosition();
        this.updateFinalPosition();
    }

    private void updateInitialPosition() {
        this.initialPosition.setMatchingFrame((FrameTuple3DReadOnly)this.initialPositionProvider.getPosition());
    }

    private void updateFinalPosition() {
        this.finalPosition.setMatchingFrame((FrameTuple3DReadOnly)this.finalPositionProvider.getPosition());
    }

    @Override
    public void compute(double time) {
        if (this.continuouslyUpdateFinalPosition.getBooleanValue()) {
            this.updateFinalPosition();
        }
        this.currentTime.set(time);
        time = MathTools.clamp((double)time, (double)0.0, (double)this.trajectoryTime.getDoubleValue());
        this.parameterPolynomial.compute(time);
        this.differenceVector.sub((FrameTuple3DReadOnly)this.finalPosition, (FrameTuple3DReadOnly)this.initialPosition);
        double parameter = this.isDone() ? 1.0 : this.parameterPolynomial.getValue();
        double parameterd = this.isDone() ? 0.0 : this.parameterPolynomial.getVelocity();
        double parameterdd = this.isDone() ? 0.0 : this.parameterPolynomial.getAcceleration();
        this.currentPosition.interpolate((FrameTuple3DReadOnly)this.initialPosition, (FrameTuple3DReadOnly)this.finalPosition, parameter);
        this.currentVelocity.setAndScale(parameterd, (FrameTuple3DReadOnly)this.differenceVector);
        this.currentAcceleration.setAndScale(parameterdd, (FrameTuple3DReadOnly)this.differenceVector);
    }

    @Override
    public boolean isDone() {
        return this.currentTime.getDoubleValue() >= this.trajectoryTime.getDoubleValue();
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.currentPosition;
    }

    @Override
    public FrameVector3DReadOnly getVelocity() {
        return this.currentVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAcceleration() {
        return this.currentAcceleration;
    }

    public void setContinuouslyUpdateFinalPosition(boolean val) {
        this.continuouslyUpdateFinalPosition.set(val);
    }

    @Override
    public void showVisualization() {
    }

    @Override
    public void hideVisualization() {
    }
}

