/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.FramePointTrapezoidalVelocityTrajectory;
import us.ihmc.robotics.math.trajectories.NDoFTrapezoidalVelocityTrajectory;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class StraightLineCartesianTrajectoryGenerator
implements FixedFramePositionTrajectoryGenerator {
    private final YoRegistry registry;
    private final ReferenceFrame referenceFrame;
    private final YoDouble time;
    private final YoDouble maxVel;
    private final YoDouble maxAccel;
    private FramePointTrapezoidalVelocityTrajectory trajectory;
    private final FixedFramePoint3DBasics initialPosition;
    private final FixedFrameVector3DBasics initialVelocity;
    private final FixedFrameVector3DBasics initialAcceleration;
    private final FixedFramePoint3DBasics finalDesiredPosition;
    private final FixedFrameVector3DBasics finalDesiredVelocity;
    private final FramePoint3D desiredPosition;
    private final FrameVector3D desiredVelocity;
    private final FrameVector3D desiredAcceleration;

    public StraightLineCartesianTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, double maxVel, double maxAccel, YoDouble time, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + "StraightLineCartesianTrajectoryGenerator");
        this.maxVel = new YoDouble("straightLineTrajMaxVel", this.registry);
        this.maxAccel = new YoDouble("straightLineTrajMaxAccel", this.registry);
        this.referenceFrame = referenceFrame;
        this.time = time;
        this.initialPosition = new FramePoint3D(referenceFrame);
        this.initialVelocity = new FrameVector3D(referenceFrame);
        this.initialAcceleration = new FrameVector3D(referenceFrame);
        this.finalDesiredPosition = new FramePoint3D(referenceFrame);
        this.finalDesiredVelocity = new FrameVector3D(referenceFrame);
        this.desiredPosition = new FramePoint3D(referenceFrame);
        this.desiredVelocity = new FrameVector3D(referenceFrame);
        this.desiredAcceleration = new FrameVector3D(referenceFrame);
        this.maxVel.set(maxVel);
        this.maxAccel.set(maxAccel);
        parentRegistry.addChild(this.registry);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public void setInitialPosition(FramePoint3DReadOnly initialPosition) {
        this.initialPosition.setMatchingFrame((FrameTuple3DReadOnly)initialPosition);
    }

    public void setInitialVelocity(FrameVector3DReadOnly initialVelocity) {
        this.initialVelocity.setMatchingFrame((FrameTuple3DReadOnly)initialVelocity);
    }

    public void setInitialAcceleration(FrameVector3DReadOnly initialAcceleration) {
        this.initialAcceleration.setMatchingFrame((FrameTuple3DReadOnly)initialAcceleration);
    }

    public void setFinalDesiredPosition(FramePoint3DReadOnly finalDesiredPosition) {
        this.finalDesiredPosition.setMatchingFrame((FrameTuple3DReadOnly)finalDesiredPosition);
    }

    public void setFinalDesiredVelocity(FrameVector3DReadOnly finalDesiredVelocity) {
        this.finalDesiredVelocity.setMatchingFrame((FrameTuple3DReadOnly)finalDesiredVelocity);
    }

    @Override
    public void initialize() {
        double maxVelDouble = this.maxVel.getDoubleValue();
        double maxAccelDouble = this.maxAccel.getDoubleValue();
        FrameVector3D vMax = new FrameVector3D(this.referenceFrame, maxVelDouble, maxVelDouble, maxVelDouble);
        FrameVector3D aMax = new FrameVector3D(this.referenceFrame, maxAccelDouble, maxAccelDouble, maxAccelDouble);
        this.trajectory = new FramePointTrapezoidalVelocityTrajectory(this.time.getDoubleValue(), (FramePoint3DReadOnly)this.initialPosition, (FramePoint3DReadOnly)this.finalDesiredPosition, (FrameVector3DReadOnly)this.initialVelocity, (FrameVector3DReadOnly)this.finalDesiredVelocity, (FrameVector3DReadOnly)vMax, (FrameVector3DReadOnly)aMax, NDoFTrapezoidalVelocityTrajectory.AlphaToAlphaType.LINEAR);
    }

    @Override
    public void compute(double time) {
        this.desiredPosition.setMatchingFrame((FrameTuple3DReadOnly)this.trajectory.getPosition(time));
        this.desiredVelocity.setMatchingFrame((FrameTuple3DReadOnly)this.trajectory.getVelocity(time));
        this.desiredAcceleration.setMatchingFrame((FrameTuple3DReadOnly)this.trajectory.getAcceleration(time));
    }

    @Override
    public boolean isDone() {
        if (this.trajectory == null) {
            return true;
        }
        return this.time.getDoubleValue() > this.trajectory.getTFMax();
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.desiredPosition;
    }

    @Override
    public FrameVector3DReadOnly getVelocity() {
        return this.desiredVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAcceleration() {
        return this.desiredAcceleration;
    }

    public double getFinalTime() {
        return this.trajectory.getTFMax();
    }

    public void setMaxVelocity(double velocity) {
        this.maxVel.set(velocity);
    }

    @Override
    public void showVisualization() {
    }

    @Override
    public void hideVisualization() {
    }
}

