/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class LinearSpatialVectorTrajectoryGenerator {
    private final String namePrefix;
    private final int maximumNumberOfWaypoints;
    private final YoRegistry registry;
    private final YoDouble currentTrajectoryTime;
    private final YoInteger numberOfWaypoints;
    private final YoInteger currentWaypointIndex;
    private final List<YoSpatialWaypoint> waypoints;
    private final YoSpatialWaypoint currentValue;

    public LinearSpatialVectorTrajectoryGenerator(String namePrefix, int maximumNumberOfWaypoints, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this.namePrefix = namePrefix;
        this.maximumNumberOfWaypoints = maximumNumberOfWaypoints;
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.currentTrajectoryTime = new YoDouble(namePrefix + "CurrentTrajectoryTime", this.registry);
        this.numberOfWaypoints = new YoInteger(namePrefix + "NumberOfWaypoints", this.registry);
        this.numberOfWaypoints.set(0);
        this.currentWaypointIndex = new YoInteger(namePrefix + "CurrentWaypointIndex", this.registry);
        this.currentValue = new YoSpatialWaypoint(namePrefix + "CurrentValue", this.registry, referenceFrame);
        this.waypoints = new ArrayList<YoSpatialWaypoint>(maximumNumberOfWaypoints);
        for (int i = 0; i < maximumNumberOfWaypoints; ++i) {
            YoSpatialWaypoint waypoint = new YoSpatialWaypoint(namePrefix + "Waypoint" + i, this.registry, referenceFrame);
            this.waypoints.add(waypoint);
        }
    }

    public void clear() {
        this.numberOfWaypoints.set(0);
        this.currentWaypointIndex.set(0);
        for (int i = 0; i < this.maximumNumberOfWaypoints; ++i) {
            this.waypoints.get(i).setToNaN();
        }
    }

    public void clear(ReferenceFrame referenceFrame) {
        this.numberOfWaypoints.set(0);
        this.currentWaypointIndex.set(0);
        for (int i = 0; i < this.maximumNumberOfWaypoints; ++i) {
            this.waypoints.get(i).setToNaN(referenceFrame);
        }
        this.currentValue.setReferenceFrame(referenceFrame);
    }

    public void appendWaypoint(double timeAtWaypoint, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, angularPart, linearPart);
    }

    private void appendWaypointUnsafe(double timeAtWaypoint, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).setIncludingFrame(this.getCurrentTrajectoryFrame(), timeAtWaypoint, angularPart, linearPart);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoint(double timeAtWaypoint, FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, angularPart, linearPart);
    }

    private void appendWaypointUnsafe(double timeAtWaypoint, FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart) {
        angularPart.checkReferenceFrameMatch(this.getCurrentTrajectoryFrame());
        linearPart.checkReferenceFrameMatch(this.getCurrentTrajectoryFrame());
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).setIncludingFrame(timeAtWaypoint, angularPart, linearPart);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoint(double timeAtWaypoint, SpatialVectorReadOnly waypoint) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, waypoint.getAngularPart(), waypoint.getLinearPart());
    }

    public void appendWaypoint(SpatialWaypointBasics waypoint) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(waypoint.getTime(), (FrameVector3DReadOnly)waypoint.getAngularPart(), (FrameVector3DReadOnly)waypoint.getLinearPart());
    }

    private void checkNumberOfWaypoints(int length) {
        if (length > this.maximumNumberOfWaypoints) {
            throw new RuntimeException("Cannot exceed the maximum number of waypoints. Number of waypoints provided: " + length);
        }
    }

    public void initialize() {
        if (this.numberOfWaypoints.getIntegerValue() == 0) {
            throw new RuntimeException("Trajectory has no waypoints.");
        }
        this.currentWaypointIndex.set(0);
    }

    public void changeFrame(ReferenceFrame desiredFrame) {
        for (int i = 0; i < this.numberOfWaypoints.getIntegerValue(); ++i) {
            this.waypoints.get(i).changeFrame(desiredFrame);
        }
        this.currentValue.changeFrame(desiredFrame);
    }

    public void compute(double time) {
        if (this.isEmpty()) {
            throw new RuntimeException("Can not call compute on an empty trajectory.");
        }
        this.currentTrajectoryTime.set(time);
        if (time < this.waypoints.get(this.currentWaypointIndex.getIntegerValue()).getTime()) {
            this.currentWaypointIndex.set(0);
        }
        while (this.currentWaypointIndex.getIntegerValue() < this.numberOfWaypoints.getIntegerValue() - 2 && time >= this.waypoints.get(this.currentWaypointIndex.getIntegerValue() + 1).getTime()) {
            this.currentWaypointIndex.increment();
        }
        int secondWaypointIndex = Math.min(this.currentWaypointIndex.getValue() + 1, this.numberOfWaypoints.getValue() - 1);
        YoSpatialWaypoint start = this.waypoints.get(this.currentWaypointIndex.getValue());
        YoSpatialWaypoint end = this.waypoints.get(secondWaypointIndex);
        double alpha = (time - start.getTime()) / (end.getTime() - start.getTime());
        alpha = MathTools.clamp((double)alpha, (double)0.0, (double)1.0);
        this.currentValue.getAngularPart().interpolate((FrameTuple3DReadOnly)start.getAngularPart(), (FrameTuple3DReadOnly)end.getAngularPart(), alpha);
        this.currentValue.getLinearPart().interpolate((FrameTuple3DReadOnly)start.getLinearPart(), (FrameTuple3DReadOnly)end.getLinearPart(), alpha);
    }

    public boolean isDone() {
        boolean isLastWaypoint;
        if (this.isEmpty()) {
            return true;
        }
        boolean bl = isLastWaypoint = this.currentWaypointIndex.getIntegerValue() >= this.numberOfWaypoints.getIntegerValue() - 2;
        if (!isLastWaypoint) {
            return false;
        }
        return this.currentTrajectoryTime.getValue() >= this.waypoints.get(this.currentWaypointIndex.getValue() + 1).getTime();
    }

    public boolean isEmpty() {
        return this.numberOfWaypoints.getIntegerValue() == 0;
    }

    public int getCurrentWaypointIndex() {
        return this.currentWaypointIndex.getIntegerValue();
    }

    public SpatialVectorReadOnly getCurrentValue() {
        return this.currentValue;
    }

    public double getLastWaypointTime() {
        return this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1).getTime();
    }

    public int getCurrentNumberOfWaypoints() {
        return this.numberOfWaypoints.getValue();
    }

    public ReferenceFrame getCurrentTrajectoryFrame() {
        return this.currentValue.getReferenceFrame();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    private static class YoSpatialWaypoint
    implements SpatialWaypointBasics {
        private final YoDouble time;
        private final FrameVector3DBasics angularPart;
        private final FrameVector3DBasics linearPart;

        public YoSpatialWaypoint(String namePrefix, YoRegistry registry, ReferenceFrame referenceFrame) {
            this.time = new YoDouble(namePrefix + "Time", registry);
            this.angularPart = new YoMutableFrameVector3D(namePrefix + "Angular", "", registry, referenceFrame);
            this.linearPart = new YoMutableFrameVector3D(namePrefix + "Linear", "", registry, referenceFrame);
        }

        @Override
        public void setTime(double time) {
            this.time.set(time);
        }

        @Override
        public double getTime() {
            return this.time.getValue();
        }

        public FixedFrameVector3DBasics getAngularPart() {
            return this.angularPart;
        }

        public FixedFrameVector3DBasics getLinearPart() {
            return this.linearPart;
        }

        public ReferenceFrame getReferenceFrame() {
            return this.linearPart.getReferenceFrame();
        }

        public void setReferenceFrame(ReferenceFrame expressedInFrame) {
            this.linearPart.setReferenceFrame(expressedInFrame);
            this.angularPart.setReferenceFrame(expressedInFrame);
        }
    }

    public static interface SpatialWaypointBasics
    extends SpatialVectorBasics {
        public void setTime(double var1);

        public double getTime();

        default public void setToZero() {
            this.setTime(0.0);
            super.setToZero();
        }

        default public void setToNaN() {
            this.setTime(Double.NaN);
            super.setToNaN();
        }

        default public boolean containsNaN() {
            return super.containsNaN();
        }

        default public void set(double time, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
            this.setTime(time);
            super.set(angularPart, linearPart);
        }

        default public void set(double time, FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart) {
            this.setTime(time);
            super.set(angularPart, linearPart);
        }

        default public void set(double time, SpatialVectorReadOnly spatialVector) {
            this.setTime(time);
            super.set(spatialVector);
        }

        default public void set(SpatialWaypointBasics other) {
            this.set(other.getTime(), (SpatialVectorReadOnly)other);
        }

        default public void setIncludingFrame(ReferenceFrame expressedInFrame, double time, Vector3DReadOnly angularPart, Vector3DReadOnly linearPart) {
            this.setTime(time);
            super.setIncludingFrame(expressedInFrame, angularPart, linearPart);
        }

        default public void setIncludingFrame(double time, FrameVector3DReadOnly angularPart, FrameVector3DReadOnly linearPart) {
            this.setTime(time);
            super.setIncludingFrame(angularPart, linearPart);
        }

        default public void setIncludingFrame(double time, SpatialVectorReadOnly spatialVector) {
            this.setTime(time);
            super.setIncludingFrame(spatialVector);
        }

        default public void setIncludingFrame(SpatialWaypointBasics other) {
            this.setIncludingFrame(other.getTime(), (SpatialVectorReadOnly)other);
        }
    }

    public static class SpatialWaypoint
    implements SpatialWaypointBasics {
        private double time;
        private final SpatialVector spatialVector = new SpatialVector();

        public SpatialWaypoint() {
            this.setToZero();
        }

        @Override
        public void setTime(double time) {
            this.time = time;
        }

        @Override
        public double getTime() {
            return this.time;
        }

        public FixedFrameVector3DBasics getAngularPart() {
            return this.spatialVector.getAngularPart();
        }

        public FixedFrameVector3DBasics getLinearPart() {
            return this.spatialVector.getLinearPart();
        }

        public ReferenceFrame getReferenceFrame() {
            return this.spatialVector.getReferenceFrame();
        }

        public void setReferenceFrame(ReferenceFrame expressedInFrame) {
            this.spatialVector.setReferenceFrame(expressedInFrame);
        }
    }
}

