/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import java.util.Arrays;
import org.apache.commons.lang3.mutable.MutableDouble;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.robotics.math.functionGenerator.BaseFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.ChirpLinearFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.SawtoothWaveFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.SineWaveFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.SquareWaveFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.TriangleWaveFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.WhiteNoiseFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGeneratorMode;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class YoFunctionGeneratorNew {
    private final YoDouble transitionDuration;
    private final InputFilter offset;
    private final InputFilter amplitude;
    private final InputFilter phase;
    private final InputFilter frequency;
    private final YoDouble chirpCurrentFrequency;
    private final InputFilter chirpLowFrequency;
    private final InputFilter chirpHighFrequency;
    private final InputFilter chirpDuration;
    private final YoDouble resetTime;
    private final InputFilter[] inputs;
    private final YoDouble angle;
    private final YoDouble value;
    private final YoDouble valueDot;
    private final YoDouble valueDDot;
    private final InputFilter modeTransition;
    private final YoEnum<YoFunctionGeneratorMode> mode;
    private final YoEnum<YoFunctionGeneratorMode> modePrevious;
    private boolean hasModeChanged = false;
    private final SineWaveFunctionGenerator sineFunction = new SineWaveFunctionGenerator();
    private final TriangleWaveFunctionGenerator triangleFunction = new TriangleWaveFunctionGenerator();
    private final SawtoothWaveFunctionGenerator sawtoothFunction = new SawtoothWaveFunctionGenerator();
    private final SquareWaveFunctionGenerator squareFunction = new SquareWaveFunctionGenerator();
    private final WhiteNoiseFunctionGenerator whiteNoiseFunction = new WhiteNoiseFunctionGenerator();
    private final ChirpLinearFunctionGenerator chirpLinearFunction = new ChirpLinearFunctionGenerator();
    private final TimeToDTConverter timeToDTConverter;
    private final DoubleProvider dt;
    private final MutableDouble valueA = new MutableDouble();
    private final MutableDouble valueDotA = new MutableDouble();
    private final MutableDouble valueDDotA = new MutableDouble();
    private final MutableDouble valueB = new MutableDouble();
    private final MutableDouble valueDotB = new MutableDouble();
    private final MutableDouble valueDDotB = new MutableDouble();

    public YoFunctionGeneratorNew(String namePrefix, YoRegistry registry) {
        this(namePrefix, null, new TimeToDTConverter(), registry);
    }

    public YoFunctionGeneratorNew(String namePrefix, DoubleProvider time, YoRegistry registry) {
        this(namePrefix, null, time, registry);
    }

    public YoFunctionGeneratorNew(String namePrefix, double dt, YoRegistry registry) {
        this(namePrefix, () -> dt, null, registry);
    }

    private YoFunctionGeneratorNew(String namePrefix, DoubleProvider dt, DoubleProvider time, YoRegistry registry) {
        this.dt = dt;
        this.timeToDTConverter = new TimeToDTConverter(time);
        this.angle = new YoDouble(namePrefix + "Angle", registry);
        this.value = new YoDouble(namePrefix + "Value", registry);
        this.valueDot = new YoDouble(namePrefix + "ValueDot", registry);
        this.valueDDot = new YoDouble(namePrefix + "ValueDDot", registry);
        this.transitionDuration = new YoDouble(namePrefix + "TransitionDurationFilt", registry);
        this.transitionDuration.set(0.5);
        this.offset = new InputFilter(namePrefix + "Offset", (DoubleProvider)this.transitionDuration, registry);
        this.amplitude = new InputFilter(namePrefix + "Amp", (DoubleProvider)this.transitionDuration, registry);
        this.phase = new InputFilter(namePrefix + "Phase", (DoubleProvider)this.transitionDuration, registry);
        this.frequency = new InputFilter(namePrefix + "Freq", (DoubleProvider)this.transitionDuration, registry);
        this.chirpCurrentFrequency = new YoDouble(namePrefix + "ChirpCurrentFreq", registry);
        this.chirpLowFrequency = new InputFilter(namePrefix + "ChirpLowFreq", (DoubleProvider)this.transitionDuration, registry);
        this.chirpHighFrequency = new InputFilter(namePrefix + "ChirpHighFreq", (DoubleProvider)this.transitionDuration, registry);
        this.chirpDuration = new InputFilter(namePrefix + "ChirpDuration", (DoubleProvider)this.transitionDuration, registry);
        this.inputs = new InputFilter[]{this.offset, this.amplitude, this.phase, this.frequency, this.chirpLowFrequency, this.chirpHighFrequency, this.chirpDuration};
        this.resetTime = new YoDouble(namePrefix + "ResetTime", registry);
        this.resetTime.set(Double.POSITIVE_INFINITY);
        this.modeTransition = new InputFilter(namePrefix + "ModeTransition", (DoubleProvider)this.transitionDuration, registry);
        this.mode = new YoEnum(namePrefix + "Mode", registry, YoFunctionGeneratorMode.class);
        this.modePrevious = new YoEnum(namePrefix + "ModePrevious", registry, YoFunctionGeneratorMode.class);
        this.mode.set((Enum)YoFunctionGeneratorMode.OFF);
        this.modePrevious.set((Enum)YoFunctionGeneratorMode.OFF);
        this.mode.addListener(v -> {
            this.hasModeChanged = true;
        });
        for (BaseFunctionGenerator function : Arrays.asList(this.sineFunction, this.triangleFunction, this.sawtoothFunction, this.squareFunction, this.whiteNoiseFunction)) {
            function.setOffset(this.offset);
            function.setAmplitude(this.amplitude);
            function.setFrequency(this.frequency);
            function.setPhase(this.phase);
        }
        this.chirpLinearFunction.setOffset(this.offset);
        this.chirpLinearFunction.setAmplitude(this.amplitude);
        this.chirpLinearFunction.setPhase(this.phase);
        this.chirpLinearFunction.setLowFrequency(this.chirpLowFrequency);
        this.chirpLinearFunction.setHighFrequency(this.chirpHighFrequency);
        this.chirpLinearFunction.setChirpDuration(this.chirpDuration);
        this.offset.set(0.0);
        this.amplitude.set(0.0);
        this.phase.set(0.0);
        this.frequency.set(1.0);
        this.chirpDuration.set(20.0);
        this.chirpLowFrequency.set(0.0);
        this.chirpHighFrequency.set(2.0);
    }

    public void reset() {
        this.angle.set(0.0);
    }

    public void update() {
        if (this.dt != null) {
            this.updateWithDT(this.dt.getValue());
        } else if (this.timeToDTConverter != null) {
            this.timeToDTConverter.update();
            this.updateWithDT(this.timeToDTConverter.getValue());
        } else {
            throw new IllegalStateException("This function generator was not properly configured with time info.");
        }
    }

    public void updateWithTime(double time) {
        if (this.dt != null) {
            throw new IllegalOperationException("This function generator was configured with DT");
        }
        this.timeToDTConverter.update(time);
        this.updateWithDT(this.timeToDTConverter.getValue());
    }

    public void updateWithDT(double dt) {
        for (InputFilter input : this.inputs) {
            input.update(dt);
        }
        if (this.mode.getValue() != YoFunctionGeneratorMode.OFF && Double.isFinite(this.resetTime.getValue())) {
            this.resetTime.sub(dt);
            if (this.resetTime.getValue() <= 0.0) {
                this.resetTime.set(0.0);
                this.mode.set((Enum)YoFunctionGeneratorMode.OFF);
            }
        }
        if (!this.isModeValid((YoFunctionGeneratorMode)this.mode.getValue())) {
            this.mode.set((Enum)YoFunctionGeneratorMode.OFF);
            return;
        }
        if (this.hasModeChanged) {
            if (this.mode.getValue() == this.modePrevious.getValue()) {
                this.hasModeChanged = false;
            } else {
                this.modeTransition.inputFiltered.set(0.0);
                this.modeTransition.set(1.0);
                this.modeTransition.hasUserInputChanged = true;
                this.initializeMode((YoFunctionGeneratorMode)this.mode.getValue());
                this.hasModeChanged = false;
            }
        }
        if (this.modeTransition.isTransitioning()) {
            this.angle.set(this.compute((YoFunctionGeneratorMode)this.modePrevious.getValue(), dt, this.valueA, this.valueDotA, this.valueDDotA));
            this.compute((YoFunctionGeneratorMode)this.mode.getValue(), dt, this.valueB, this.valueDotB, this.valueDDotB);
            this.value.set(EuclidCoreTools.interpolate((double)this.valueA.getValue(), (double)this.valueB.getValue(), (double)this.modeTransition.getValue()));
            this.valueDot.set(EuclidCoreTools.interpolate((double)this.valueDotA.getValue(), (double)this.valueDotB.getValue(), (double)this.modeTransition.getValue()));
            this.valueDDot.set(EuclidCoreTools.interpolate((double)this.valueDDotA.getValue(), (double)this.valueDDotB.getValue(), (double)this.modeTransition.getValue()));
            this.modeTransition.update(dt);
            if (!this.modeTransition.isTransitioning()) {
                this.modePrevious.set((Enum)((YoFunctionGeneratorMode)this.mode.getValue()));
            }
        } else {
            this.angle.set(this.compute((YoFunctionGeneratorMode)this.mode.getValue(), dt, this.valueA, this.valueDotA, this.valueDDotA));
            this.value.set(this.valueA.doubleValue());
            this.valueDot.set(this.valueDotA.doubleValue());
            this.valueDDot.set(this.valueDDotA.doubleValue());
            if (this.mode.getValue() == YoFunctionGeneratorMode.CHIRP_LINEAR) {
                this.chirpCurrentFrequency.set(this.chirpLinearFunction.getFrequency());
            }
        }
    }

    private boolean isModeValid(YoFunctionGeneratorMode mode) {
        switch (mode) {
            case OFF: 
            case DC: 
            case WHITE_NOISE: 
            case SQUARE: 
            case SINE: 
            case SAWTOOTH: 
            case TRIANGLE: 
            case CHIRP_LINEAR: {
                return true;
            }
        }
        return false;
    }

    private void initializeMode(YoFunctionGeneratorMode mode) {
        switch (mode) {
            case SQUARE: {
                this.squareFunction.resetAngle();
                return;
            }
            case SINE: {
                this.sineFunction.resetAngle();
                return;
            }
            case SAWTOOTH: {
                this.sawtoothFunction.resetAngle();
                return;
            }
            case TRIANGLE: {
                this.triangleFunction.resetAngle();
                return;
            }
            case CHIRP_LINEAR: {
                this.chirpLinearFunction.resetChirp();
                return;
            }
        }
    }

    private double compute(YoFunctionGeneratorMode mode, double dt, MutableDouble value, MutableDouble valueDot, MutableDouble valueDDot) {
        switch (mode) {
            case OFF: {
                return this.computeOff(value, valueDot, valueDDot);
            }
            case DC: {
                return this.computeDC(value, valueDot, valueDDot);
            }
            case WHITE_NOISE: {
                return this.computeFunction(this.whiteNoiseFunction, dt, value, valueDot, valueDDot);
            }
            case SQUARE: {
                return this.computeFunction(this.squareFunction, dt, value, valueDot, valueDDot);
            }
            case SINE: {
                return this.computeFunction(this.sineFunction, dt, value, valueDot, valueDDot);
            }
            case SAWTOOTH: {
                return this.computeFunction(this.sawtoothFunction, dt, value, valueDot, valueDDot);
            }
            case TRIANGLE: {
                return this.computeFunction(this.triangleFunction, dt, value, valueDot, valueDDot);
            }
            case CHIRP_LINEAR: {
                return this.computeChirpLinear(dt, value, valueDot, valueDDot);
            }
        }
        return Double.NaN;
    }

    private double computeOff(MutableDouble value, MutableDouble valueDot, MutableDouble valueDDot) {
        value.setValue(this.offset.getValue());
        valueDot.setValue(0.0);
        valueDDot.setValue(0.0);
        return 0.0;
    }

    private double computeDC(MutableDouble value, MutableDouble valueDot, MutableDouble valueDDot) {
        value.setValue(this.offset.getValue() + this.amplitude.getValue());
        valueDot.setValue(0.0);
        valueDDot.setValue(0.0);
        return 0.0;
    }

    private double computeFunction(BaseFunctionGenerator function, double dt, MutableDouble value, MutableDouble valueDot, MutableDouble valueDDot) {
        function.integrateAngle(dt);
        value.setValue(function.getValue());
        valueDot.setValue(function.getValueDot());
        valueDDot.setValue(function.getValueDDot());
        return function.getAngle();
    }

    private double computeChirpLinear(double dt, MutableDouble value, MutableDouble valueDot, MutableDouble valueDDot) {
        this.chirpLinearFunction.integrateAngle(dt);
        value.setValue(this.chirpLinearFunction.getValue());
        valueDot.setValue(this.chirpLinearFunction.getValueDot());
        valueDDot.setValue(this.chirpLinearFunction.getValueDDot());
        return this.chirpLinearFunction.getAngle();
    }

    public double getValue() {
        return this.value.getValue();
    }

    public double getValueDot() {
        return this.valueDot.getValue();
    }

    public double getValueDDot() {
        return this.valueDDot.getValue();
    }

    public void setTransitionDuration(double transitionDuration) {
        this.transitionDuration.set(transitionDuration);
    }

    public void setOffset(double offset) {
        this.offset.set(offset);
    }

    public void setAmplitude(double amplitude) {
        this.amplitude.set(amplitude);
    }

    public void setPhase(double phase) {
        this.phase.set(phase);
    }

    public void setFrequency(double frequency) {
        this.frequency.set(frequency);
    }

    public void setChirpLowFrequency(double chirpLowFrequency) {
        this.chirpLowFrequency.set(chirpLowFrequency);
    }

    public void setChirpHighFrequency(double chirpHighFrequency) {
        this.chirpHighFrequency.set(chirpHighFrequency);
    }

    public void setChirpDuration(double chirpDuration) {
        this.chirpDuration.set(chirpDuration);
    }

    public void setResetTime(double resetTime) {
        this.resetTime.set(resetTime);
    }

    public void setMode(YoFunctionGeneratorMode mode) {
        this.mode.set((Enum)mode);
    }

    public double getOffset() {
        return this.offset.getValue();
    }

    public double getAmplitude() {
        return this.amplitude.getValue();
    }

    public double getPhase() {
        return this.phase.getValue();
    }

    public double getFrequency() {
        return this.frequency.getValue();
    }

    public double getChirpLowFrequency() {
        return this.chirpLowFrequency.getValue();
    }

    public double getChirpHighFrequency() {
        return this.chirpHighFrequency.getValue();
    }

    public double getChirpDuration() {
        return this.chirpDuration.getValue();
    }

    public double getResetTime() {
        return this.resetTime.getValue();
    }

    public YoDouble getAngle() {
        return this.angle;
    }

    public YoFunctionGeneratorMode getMode() {
        return (YoFunctionGeneratorMode)this.mode.getValue();
    }

    public YoFunctionGeneratorMode getModePrevious() {
        return (YoFunctionGeneratorMode)this.modePrevious.getValue();
    }

    private static class TimeToDTConverter
    implements DoubleProvider {
        private double dt = 0.0;
        private double timePrevious = Double.NaN;
        private final DoubleProvider time;

        public TimeToDTConverter() {
            this(null);
        }

        public TimeToDTConverter(DoubleProvider time) {
            this.time = time;
        }

        public void update() {
            this.update(this.time.getValue());
        }

        public void update(double time) {
            if (Double.isNaN(this.timePrevious)) {
                this.timePrevious = time;
            } else {
                this.dt = time - this.timePrevious;
            }
        }

        public double getValue() {
            return this.dt;
        }
    }

    private static class InputFilter
    implements DoubleProvider {
        private final YoDouble input;
        private final YoDouble inputFiltered;
        private final YoDouble filterRamp;
        private final DoubleProvider transitionDuration;
        private boolean hasUserInputChanged = true;

        public InputFilter(String inputName, DoubleProvider transitionDuration, YoRegistry registry) {
            this.transitionDuration = transitionDuration;
            this.input = new YoDouble(inputName, registry);
            this.input.addListener(v -> {
                this.hasUserInputChanged = true;
            });
            this.inputFiltered = new YoDouble(inputName + "Filt", registry);
            this.filterRamp = new YoDouble(inputName + "FiltRamp", registry);
        }

        public void update(double dt) {
            double desiredValue = this.input.getValue();
            if (this.hasUserInputChanged) {
                this.hasUserInputChanged = false;
                double currentValue = this.inputFiltered.getValue();
                if (this.transitionDuration.getValue() < dt) {
                    this.inputFiltered.set(desiredValue);
                    this.filterRamp.set(0.0);
                } else {
                    this.filterRamp.set((desiredValue - currentValue) / this.transitionDuration.getValue());
                }
            }
            if (this.filterRamp.getValue() != 0.0) {
                double nextValue = this.inputFiltered.getValue() + this.filterRamp.getValue() * dt;
                if ((desiredValue - nextValue) * this.filterRamp.getValue() <= 0.0) {
                    nextValue = desiredValue;
                    this.filterRamp.set(0.0);
                }
                this.inputFiltered.set(nextValue);
            }
        }

        public boolean isTransitioning() {
            return this.input.getValue() != this.inputFiltered.getValue();
        }

        public void set(double value) {
            this.input.set(value);
        }

        public double getValue() {
            return this.inputFiltered.getValue();
        }
    }
}

