/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.robotics.math.functionGenerator.BaseFunctionGenerator;

public class TriangleWaveFunctionGenerator
extends BaseFunctionGenerator {
    @Override
    protected double computeValue() {
        double angle = this.getAngle();
        double offset = this.getOffset();
        double amplitude = this.getAmplitude();
        if (angle <= Math.PI) {
            double alpha = angle / Math.PI;
            return offset + EuclidCoreTools.interpolate((double)(-amplitude), (double)amplitude, (double)alpha);
        }
        double alpha = (angle - Math.PI) / Math.PI;
        return offset + EuclidCoreTools.interpolate((double)amplitude, (double)(-amplitude), (double)alpha);
    }

    @Override
    protected double computeValueDot() {
        double angle = this.getAngle();
        double amplitude = this.getAmplitude();
        double frequency = this.getFrequency();
        return (angle <= Math.PI ? 1.0 : -1.0) * (4.0 * amplitude * frequency);
    }

    @Override
    protected double computeValueDDot() {
        return 0.0;
    }
}

