/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.robotics.math.filters.SimpleMovingAverageFilteredYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimpleMovingAverageFilteredYoFrameVector
extends YoFrameVector3D
implements ProcessingYoVariable {
    private final SimpleMovingAverageFilteredYoVariable x;
    private final SimpleMovingAverageFilteredYoVariable y;
    private final SimpleMovingAverageFilteredYoVariable z;

    private SimpleMovingAverageFilteredYoFrameVector(SimpleMovingAverageFilteredYoVariable x, SimpleMovingAverageFilteredYoVariable y, SimpleMovingAverageFilteredYoVariable z, ReferenceFrame referenceFrame) {
        super((YoDouble)x, (YoDouble)y, (YoDouble)z, referenceFrame);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static SimpleMovingAverageFilteredYoFrameVector createSimpleMovingAverageFilteredYoFrameVector(String namePrefix, String nameSuffix, int windowSize, ReferenceFrame referenceFrame, YoRegistry registry) {
        String xName = YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix);
        String yName = YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix);
        String zName = YoGeometryNameTools.createZName((String)namePrefix, (String)nameSuffix);
        SimpleMovingAverageFilteredYoVariable x = new SimpleMovingAverageFilteredYoVariable(xName, windowSize, registry);
        SimpleMovingAverageFilteredYoVariable y = new SimpleMovingAverageFilteredYoVariable(yName, windowSize, registry);
        SimpleMovingAverageFilteredYoVariable z = new SimpleMovingAverageFilteredYoVariable(zName, windowSize, registry);
        return new SimpleMovingAverageFilteredYoFrameVector(x, y, z, referenceFrame);
    }

    public static SimpleMovingAverageFilteredYoFrameVector createSimpleMovingAverageFilteredYoFrameVector(String namePrefix, String nameSuffix, int windowSize, YoFrameVector3D unfilteredVector, YoRegistry registry) {
        String xName = YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix);
        String yName = YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix);
        String zName = YoGeometryNameTools.createZName((String)namePrefix, (String)nameSuffix);
        SimpleMovingAverageFilteredYoVariable x = new SimpleMovingAverageFilteredYoVariable(xName, windowSize, unfilteredVector.getYoX(), registry);
        SimpleMovingAverageFilteredYoVariable y = new SimpleMovingAverageFilteredYoVariable(yName, windowSize, unfilteredVector.getYoY(), registry);
        SimpleMovingAverageFilteredYoVariable z = new SimpleMovingAverageFilteredYoVariable(zName, windowSize, unfilteredVector.getYoZ(), registry);
        return new SimpleMovingAverageFilteredYoFrameVector(x, y, z, unfilteredVector.getReferenceFrame());
    }

    @Override
    public void update() {
        this.x.update();
        this.y.update();
        this.z.update();
    }

    public void update(double xUnfiltered, double yUnfiltered, double zUnfiltered) {
        this.x.update(xUnfiltered);
        this.y.update(yUnfiltered);
        this.z.update(zUnfiltered);
    }

    public void update(Vector3D vectorUnfiltered) {
        this.x.update(vectorUnfiltered.getX());
        this.y.update(vectorUnfiltered.getY());
        this.z.update(vectorUnfiltered.getZ());
    }

    public void update(FrameVector3D vectorUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)vectorUnfiltered);
        this.x.update(vectorUnfiltered.getX());
        this.y.update(vectorUnfiltered.getY());
        this.z.update(vectorUnfiltered.getZ());
    }

    @Override
    public void reset() {
        this.x.reset();
        this.y.reset();
        this.z.reset();
    }

    public boolean getHasBufferWindowFilled() {
        return this.x.getHasBufferWindowFilled() && this.y.getHasBufferWindowFilled() && this.z.getHasBufferWindowFilled();
    }
}

